@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Group].
 */
@PulumiTagMarker
public class GroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GroupArgs = GroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GroupArgsBuilder.() -> Unit) {
        val builder = GroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Group {
        val builtJavaResource = com.pulumi.alicloud.dns.Group(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Group(builtJavaResource)
    }
}

/**
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.84.0`. Please use new resource alicloud_alidns_domain_group.
 * Provides a DNS Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain group.
 * const group = new alicloud.dns.Group("group", {name: "testgroup"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain group.
 * group = alicloud.dns.Group("group", name="testgroup")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain group.
 *     var @group = new AliCloud.Dns.Group("group", new()
 *     {
 *         Name = "testgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain group.
 * 		_, err := dns.NewGroup(ctx, "group", &dns.GroupArgs{
 * 			Name: pulumi.String("testgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Group;
 * import com.pulumi.alicloud.dns.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain group.
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("testgroup")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain group.
 *   group:
 *     type: alicloud:dns:Group
 *     properties:
 *       name: testgroup
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Group internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.Group,
) : KotlinCustomResource(javaResource, GroupMapper) {
    /**
     * Name of the domain group.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })
}

public object GroupMapper : ResourceMapper<Group> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.Group::class == javaResource::class

    override fun map(javaResource: Resource): Group = Group(
        javaResource as
            com.pulumi.alicloud.dns.Group,
    )
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Group].
 */
public suspend fun group(name: String, block: suspend GroupResourceBuilder.() -> Unit): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Group].
 * @param name The _unique_ name of the resulting resource.
 */
public fun group(name: String): Group {
    val builder = GroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
