@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.GroupArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.84.0`. Please use new resource alicloud_alidns_domain_group.
 * Provides a DNS Group resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Add a new Domain group.
 * const group = new alicloud.dns.Group("group", {name: "testgroup"});
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Add a new Domain group.
 * group = alicloud.dns.Group("group", name="testgroup")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Add a new Domain group.
 *     var @group = new AliCloud.Dns.Group("group", new()
 *     {
 *         Name = "testgroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Add a new Domain group.
 * 		_, err := dns.NewGroup(ctx, "group", &dns.GroupArgs{
 * 			Name: pulumi.String("testgroup"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Group;
 * import com.pulumi.alicloud.dns.GroupArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Add a new Domain group.
 *         var group = new Group("group", GroupArgs.builder()
 *             .name("testgroup")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Add a new Domain group.
 *   group:
 *     type: alicloud:dns:Group
 *     properties:
 *       name: testgroup
 * ```
 * <!--End PulumiCodeChooser -->
 * @property name Name of the domain group.
 */
public data class GroupArgs(
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.GroupArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.GroupArgs =
        com.pulumi.alicloud.dns.GroupArgs.builder()
            .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupArgs].
 */
@PulumiTagMarker
public class GroupArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    /**
     * @param value Name of the domain group.
     */
    @JvmName("jfbhcjbsetolsceu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Name of the domain group.
     */
    @JvmName("dnjfkttvucagdeqo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): GroupArgs = GroupArgs(
        name = name,
    )
}
