@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.kotlin.outputs.GtmInstanceAlertConfig
import com.pulumi.alicloud.dns.kotlin.outputs.GtmInstanceAlertConfig.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [GtmInstance].
 */
@PulumiTagMarker
public class GtmInstanceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: GtmInstanceArgs = GtmInstanceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend GtmInstanceArgsBuilder.() -> Unit) {
        val builder = GtmInstanceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): GtmInstance {
        val builtJavaResource = com.pulumi.alicloud.dns.GtmInstance(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return GtmInstance(builtJavaResource)
    }
}

/**
 * Provides a Alidns Gtm Instance resource.
 * For information about Alidns Gtm Instance and how to use it, see [What is Gtm Instance](https://www.alibabacloud.com/help/en/doc-detail/204852.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const domainName = config.get("domainName") || "alicloud-provider.com";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: "tf_example"});
 * const defaultGtmInstance = new alicloud.dns.GtmInstance("default", {
 *     instanceName: "tf_example",
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     packageEdition: "standard",
 *     healthCheckTaskCount: 100,
 *     smsNotificationCount: 1000,
 *     publicCnameMode: "SYSTEM_ASSIGN",
 *     ttl: 60,
 *     cnameType: "PUBLIC",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     alertGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     publicUserDomainName: domainName,
 *     alertConfigs: [{
 *         smsNotice: true,
 *         noticeType: "ADDR_ALERT",
 *         emailNotice: true,
 *         dingtalkNotice: true,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "alicloud-provider.com"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name="tf_example")
 * default_gtm_instance = alicloud.dns.GtmInstance("default",
 *     instance_name="tf_example",
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     package_edition="standard",
 *     health_check_task_count=100,
 *     sms_notification_count=1000,
 *     public_cname_mode="SYSTEM_ASSIGN",
 *     ttl=60,
 *     cname_type="PUBLIC",
 *     resource_group_id=default.groups[0].id,
 *     alert_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     public_user_domain_name=domain_name,
 *     alert_configs=[{
 *         "sms_notice": True,
 *         "notice_type": "ADDR_ALERT",
 *         "email_notice": True,
 *         "dingtalk_notice": True,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var domainName = config.Get("domainName") ?? "alicloud-provider.com";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = "tf_example",
 *     });
 *     var defaultGtmInstance = new AliCloud.Dns.GtmInstance("default", new()
 *     {
 *         InstanceName = "tf_example",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         PackageEdition = "standard",
 *         HealthCheckTaskCount = 100,
 *         SmsNotificationCount = 1000,
 *         PublicCnameMode = "SYSTEM_ASSIGN",
 *         Ttl = 60,
 *         CnameType = "PUBLIC",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AlertGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         PublicUserDomainName = domainName,
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.Dns.Inputs.GtmInstanceAlertConfigArgs
 *             {
 *                 SmsNotice = true,
 *                 NoticeType = "ADDR_ALERT",
 *                 EmailNotice = true,
 *                 DingtalkNotice = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		domainName := "alicloud-provider.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewGtmInstance(ctx, "default", &dns.GtmInstanceArgs{
 * 			InstanceName:         pulumi.String("tf_example"),
 * 			PaymentType:          pulumi.String("Subscription"),
 * 			Period:               pulumi.Int(1),
 * 			RenewalStatus:        pulumi.String("ManualRenewal"),
 * 			PackageEdition:       pulumi.String("standard"),
 * 			HealthCheckTaskCount: pulumi.Int(100),
 * 			SmsNotificationCount: pulumi.Int(1000),
 * 			PublicCnameMode:      pulumi.String("SYSTEM_ASSIGN"),
 * 			Ttl:                  pulumi.Int(60),
 * 			CnameType:            pulumi.String("PUBLIC"),
 * 			ResourceGroupId:      pulumi.String(_default.Groups[0].Id),
 * 			AlertGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			PublicUserDomainName: pulumi.String(domainName),
 * 			AlertConfigs: dns.GtmInstanceAlertConfigArray{
 * 				&dns.GtmInstanceAlertConfigArgs{
 * 					SmsNotice:      pulumi.Bool(true),
 * 					NoticeType:     pulumi.String("ADDR_ALERT"),
 * 					EmailNotice:    pulumi.Bool(true),
 * 					DingtalkNotice: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.dns.GtmInstance;
 * import com.pulumi.alicloud.dns.GtmInstanceArgs;
 * import com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domainName = config.get("domainName").orElse("alicloud-provider.com");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName("tf_example")
 *             .build());
 *         var defaultGtmInstance = new GtmInstance("defaultGtmInstance", GtmInstanceArgs.builder()
 *             .instanceName("tf_example")
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .packageEdition("standard")
 *             .healthCheckTaskCount(100)
 *             .smsNotificationCount(1000)
 *             .publicCnameMode("SYSTEM_ASSIGN")
 *             .ttl(60)
 *             .cnameType("PUBLIC")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .alertGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .publicUserDomainName(domainName)
 *             .alertConfigs(GtmInstanceAlertConfigArgs.builder()
 *                 .smsNotice(true)
 *                 .noticeType("ADDR_ALERT")
 *                 .emailNotice(true)
 *                 .dingtalkNotice(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   domainName:
 *     type: string
 *     default: alicloud-provider.com
 * resources:
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: tf_example
 *   defaultGtmInstance:
 *     type: alicloud:dns:GtmInstance
 *     name: default
 *     properties:
 *       instanceName: tf_example
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       packageEdition: standard
 *       healthCheckTaskCount: 100
 *       smsNotificationCount: 1000
 *       publicCnameMode: SYSTEM_ASSIGN
 *       ttl: 60
 *       cnameType: PUBLIC
 *       resourceGroupId: ${default.groups[0].id}
 *       alertGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       publicUserDomainName: ${domainName}
 *       alertConfigs:
 *         - smsNotice: true
 *           noticeType: ADDR_ALERT
 *           emailNotice: true
 *           dingtalkNotice: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Gtm Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/gtmInstance:GtmInstance example <id>
 * ```
 */
public class GtmInstance internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.GtmInstance,
) : KotlinCustomResource(javaResource, GtmInstanceMapper) {
    /**
     * The alert notification methods. See `alert_config` below for details.
     */
    public val alertConfigs: Output<List<GtmInstanceAlertConfig>>?
        get() = javaResource.alertConfigs().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> toKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The alert group.
     */
    public val alertGroups: Output<List<String>>?
        get() = javaResource.alertGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * The access type of the CNAME domain name. Valid value: `PUBLIC`.
     */
    public val cnameType: Output<String>
        get() = javaResource.cnameType().applyValue({ args0 -> args0 })

    /**
     * The force update.
     */
    public val forceUpdate: Output<Boolean>?
        get() = javaResource.forceUpdate().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The quota of detection tasks.
     */
    public val healthCheckTaskCount: Output<Int>
        get() = javaResource.healthCheckTaskCount().applyValue({ args0 -> args0 })

    /**
     * The name of the instance.
     */
    public val instanceName: Output<String>
        get() = javaResource.instanceName().applyValue({ args0 -> args0 })

    /**
     * The lang.
     */
    public val lang: Output<String>?
        get() = javaResource.lang().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Paid package version. Valid values: `ultimate`, `standard`.
     */
    public val packageEdition: Output<String>
        get() = javaResource.packageEdition().applyValue({ args0 -> args0 })

    /**
     * The Payment Type of the resource. Valid value: `Subscription`.
     */
    public val paymentType: Output<String>
        get() = javaResource.paymentType().applyValue({ args0 -> args0 })

    /**
     * Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    public val period: Output<Int>
        get() = javaResource.period().applyValue({ args0 -> args0 })

    /**
     * The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
     */
    public val publicCnameMode: Output<String>
        get() = javaResource.publicCnameMode().applyValue({ args0 -> args0 })

    /**
     * The CNAME access domain name.
     */
    public val publicRr: Output<String>
        get() = javaResource.publicRr().applyValue({ args0 -> args0 })

    /**
     * The website domain name that the user uses on the Internet.
     */
    public val publicUserDomainName: Output<String>
        get() = javaResource.publicUserDomainName().applyValue({ args0 -> args0 })

    /**
     * The domain name that is used to access GTM over the Internet.
     */
    public val publicZoneName: Output<String>
        get() = javaResource.publicZoneName().applyValue({ args0 -> args0 })

    /**
     * Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
     */
    public val renewPeriod: Output<Int>?
        get() = javaResource.renewPeriod().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    public val renewalStatus: Output<String>
        get() = javaResource.renewalStatus().applyValue({ args0 -> args0 })

    /**
     * The ID of the resource group.
     */
    public val resourceGroupId: Output<String>?
        get() = javaResource.resourceGroupId().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The quota of SMS notifications.
     */
    public val smsNotificationCount: Output<Int>
        get() = javaResource.smsNotificationCount().applyValue({ args0 -> args0 })

    /**
     * The type of the access policy. Valid values: `GEO`, `LATENCY`.
     */
    public val strategyMode: Output<String>
        get() = javaResource.strategyMode().applyValue({ args0 -> args0 })

    /**
     * The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
     */
    public val ttl: Output<Int>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })
}

public object GtmInstanceMapper : ResourceMapper<GtmInstance> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.GtmInstance::class == javaResource::class

    override fun map(javaResource: Resource): GtmInstance = GtmInstance(
        javaResource as
            com.pulumi.alicloud.dns.GtmInstance,
    )
}

/**
 * @see [GtmInstance].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [GtmInstance].
 */
public suspend fun gtmInstance(name: String, block: suspend GtmInstanceResourceBuilder.() -> Unit): GtmInstance {
    val builder = GtmInstanceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [GtmInstance].
 * @param name The _unique_ name of the resulting resource.
 */
public fun gtmInstance(name: String): GtmInstance {
    val builder = GtmInstanceResourceBuilder()
    builder.name(name)
    return builder.build()
}
