@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.GtmInstanceArgs.builder
import com.pulumi.alicloud.dns.kotlin.inputs.GtmInstanceAlertConfigArgs
import com.pulumi.alicloud.dns.kotlin.inputs.GtmInstanceAlertConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a Alidns Gtm Instance resource.
 * For information about Alidns Gtm Instance and how to use it, see [What is Gtm Instance](https://www.alibabacloud.com/help/en/doc-detail/204852.html).
 * > **NOTE:** Available since v1.151.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const domainName = config.get("domainName") || "alicloud-provider.com";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: "tf_example"});
 * const defaultGtmInstance = new alicloud.dns.GtmInstance("default", {
 *     instanceName: "tf_example",
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     packageEdition: "standard",
 *     healthCheckTaskCount: 100,
 *     smsNotificationCount: 1000,
 *     publicCnameMode: "SYSTEM_ASSIGN",
 *     ttl: 60,
 *     cnameType: "PUBLIC",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     alertGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     publicUserDomainName: domainName,
 *     alertConfigs: [{
 *         smsNotice: true,
 *         noticeType: "ADDR_ALERT",
 *         emailNotice: true,
 *         dingtalkNotice: true,
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "alicloud-provider.com"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name="tf_example")
 * default_gtm_instance = alicloud.dns.GtmInstance("default",
 *     instance_name="tf_example",
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     package_edition="standard",
 *     health_check_task_count=100,
 *     sms_notification_count=1000,
 *     public_cname_mode="SYSTEM_ASSIGN",
 *     ttl=60,
 *     cname_type="PUBLIC",
 *     resource_group_id=default.groups[0].id,
 *     alert_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     public_user_domain_name=domain_name,
 *     alert_configs=[{
 *         "sms_notice": True,
 *         "notice_type": "ADDR_ALERT",
 *         "email_notice": True,
 *         "dingtalk_notice": True,
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var domainName = config.Get("domainName") ?? "alicloud-provider.com";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = "tf_example",
 *     });
 *     var defaultGtmInstance = new AliCloud.Dns.GtmInstance("default", new()
 *     {
 *         InstanceName = "tf_example",
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         PackageEdition = "standard",
 *         HealthCheckTaskCount = 100,
 *         SmsNotificationCount = 1000,
 *         PublicCnameMode = "SYSTEM_ASSIGN",
 *         Ttl = 60,
 *         CnameType = "PUBLIC",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AlertGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         PublicUserDomainName = domainName,
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.Dns.Inputs.GtmInstanceAlertConfigArgs
 *             {
 *                 SmsNotice = true,
 *                 NoticeType = "ADDR_ALERT",
 *                 EmailNotice = true,
 *                 DingtalkNotice = true,
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		domainName := "alicloud-provider.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String("tf_example"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewGtmInstance(ctx, "default", &dns.GtmInstanceArgs{
 * 			InstanceName:         pulumi.String("tf_example"),
 * 			PaymentType:          pulumi.String("Subscription"),
 * 			Period:               pulumi.Int(1),
 * 			RenewalStatus:        pulumi.String("ManualRenewal"),
 * 			PackageEdition:       pulumi.String("standard"),
 * 			HealthCheckTaskCount: pulumi.Int(100),
 * 			SmsNotificationCount: pulumi.Int(1000),
 * 			PublicCnameMode:      pulumi.String("SYSTEM_ASSIGN"),
 * 			Ttl:                  pulumi.Int(60),
 * 			CnameType:            pulumi.String("PUBLIC"),
 * 			ResourceGroupId:      pulumi.String(_default.Groups[0].Id),
 * 			AlertGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			PublicUserDomainName: pulumi.String(domainName),
 * 			AlertConfigs: dns.GtmInstanceAlertConfigArray{
 * 				&dns.GtmInstanceAlertConfigArgs{
 * 					SmsNotice:      pulumi.Bool(true),
 * 					NoticeType:     pulumi.String("ADDR_ALERT"),
 * 					EmailNotice:    pulumi.Bool(true),
 * 					DingtalkNotice: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.dns.GtmInstance;
 * import com.pulumi.alicloud.dns.GtmInstanceArgs;
 * import com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var domainName = config.get("domainName").orElse("alicloud-provider.com");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName("tf_example")
 *             .build());
 *         var defaultGtmInstance = new GtmInstance("defaultGtmInstance", GtmInstanceArgs.builder()
 *             .instanceName("tf_example")
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .packageEdition("standard")
 *             .healthCheckTaskCount(100)
 *             .smsNotificationCount(1000)
 *             .publicCnameMode("SYSTEM_ASSIGN")
 *             .ttl(60)
 *             .cnameType("PUBLIC")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .alertGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .publicUserDomainName(domainName)
 *             .alertConfigs(GtmInstanceAlertConfigArgs.builder()
 *                 .smsNotice(true)
 *                 .noticeType("ADDR_ALERT")
 *                 .emailNotice(true)
 *                 .dingtalkNotice(true)
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   domainName:
 *     type: string
 *     default: alicloud-provider.com
 * resources:
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: tf_example
 *   defaultGtmInstance:
 *     type: alicloud:dns:GtmInstance
 *     name: default
 *     properties:
 *       instanceName: tf_example
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       packageEdition: standard
 *       healthCheckTaskCount: 100
 *       smsNotificationCount: 1000
 *       publicCnameMode: SYSTEM_ASSIGN
 *       ttl: 60
 *       cnameType: PUBLIC
 *       resourceGroupId: ${default.groups[0].id}
 *       alertGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       publicUserDomainName: ${domainName}
 *       alertConfigs:
 *         - smsNotice: true
 *           noticeType: ADDR_ALERT
 *           emailNotice: true
 *           dingtalkNotice: true
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Alidns Gtm Instance can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/gtmInstance:GtmInstance example <id>
 * ```
 * @property alertConfigs The alert notification methods. See `alert_config` below for details.
 * @property alertGroups The alert group.
 * @property cnameType The access type of the CNAME domain name. Valid value: `PUBLIC`.
 * @property forceUpdate The force update.
 * @property healthCheckTaskCount The quota of detection tasks.
 * @property instanceName The name of the instance.
 * @property lang The lang.
 * @property packageEdition Paid package version. Valid values: `ultimate`, `standard`.
 * @property paymentType The Payment Type of the resource. Valid value: `Subscription`.
 * @property period Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
 * @property publicCnameMode The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
 * @property publicRr The CNAME access domain name.
 * @property publicUserDomainName The website domain name that the user uses on the Internet.
 * @property publicZoneName The domain name that is used to access GTM over the Internet.
 * @property renewPeriod Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
 * @property resourceGroupId The ID of the resource group.
 * @property smsNotificationCount The quota of SMS notifications.
 * @property strategyMode The type of the access policy. Valid values: `GEO`, `LATENCY`.
 * @property ttl The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
 */
public data class GtmInstanceArgs(
    public val alertConfigs: Output<List<GtmInstanceAlertConfigArgs>>? = null,
    public val alertGroups: Output<List<String>>? = null,
    public val cnameType: Output<String>? = null,
    public val forceUpdate: Output<Boolean>? = null,
    public val healthCheckTaskCount: Output<Int>? = null,
    public val instanceName: Output<String>? = null,
    public val lang: Output<String>? = null,
    public val packageEdition: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val publicCnameMode: Output<String>? = null,
    public val publicRr: Output<String>? = null,
    public val publicUserDomainName: Output<String>? = null,
    public val publicZoneName: Output<String>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val resourceGroupId: Output<String>? = null,
    public val smsNotificationCount: Output<Int>? = null,
    public val strategyMode: Output<String>? = null,
    public val ttl: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.GtmInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.GtmInstanceArgs =
        com.pulumi.alicloud.dns.GtmInstanceArgs.builder()
            .alertConfigs(
                alertConfigs?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .alertGroups(alertGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .cnameType(cnameType?.applyValue({ args0 -> args0 }))
            .forceUpdate(forceUpdate?.applyValue({ args0 -> args0 }))
            .healthCheckTaskCount(healthCheckTaskCount?.applyValue({ args0 -> args0 }))
            .instanceName(instanceName?.applyValue({ args0 -> args0 }))
            .lang(lang?.applyValue({ args0 -> args0 }))
            .packageEdition(packageEdition?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .publicCnameMode(publicCnameMode?.applyValue({ args0 -> args0 }))
            .publicRr(publicRr?.applyValue({ args0 -> args0 }))
            .publicUserDomainName(publicUserDomainName?.applyValue({ args0 -> args0 }))
            .publicZoneName(publicZoneName?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.applyValue({ args0 -> args0 }))
            .smsNotificationCount(smsNotificationCount?.applyValue({ args0 -> args0 }))
            .strategyMode(strategyMode?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GtmInstanceArgs].
 */
@PulumiTagMarker
public class GtmInstanceArgsBuilder internal constructor() {
    private var alertConfigs: Output<List<GtmInstanceAlertConfigArgs>>? = null

    private var alertGroups: Output<List<String>>? = null

    private var cnameType: Output<String>? = null

    private var forceUpdate: Output<Boolean>? = null

    private var healthCheckTaskCount: Output<Int>? = null

    private var instanceName: Output<String>? = null

    private var lang: Output<String>? = null

    private var packageEdition: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var publicCnameMode: Output<String>? = null

    private var publicRr: Output<String>? = null

    private var publicUserDomainName: Output<String>? = null

    private var publicZoneName: Output<String>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var resourceGroupId: Output<String>? = null

    private var smsNotificationCount: Output<Int>? = null

    private var strategyMode: Output<String>? = null

    private var ttl: Output<Int>? = null

    /**
     * @param value The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("cjwynfkprxewrmct")
    public suspend fun alertConfigs(`value`: Output<List<GtmInstanceAlertConfigArgs>>) {
        this.alertConfigs = value
    }

    @JvmName("tjhonjkitfthljyx")
    public suspend fun alertConfigs(vararg values: Output<GtmInstanceAlertConfigArgs>) {
        this.alertConfigs = Output.all(values.asList())
    }

    /**
     * @param values The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("smhxijiphcrkvkvy")
    public suspend fun alertConfigs(values: List<Output<GtmInstanceAlertConfigArgs>>) {
        this.alertConfigs = Output.all(values)
    }

    /**
     * @param value The alert group.
     */
    @JvmName("oejabkgnfjvmnenn")
    public suspend fun alertGroups(`value`: Output<List<String>>) {
        this.alertGroups = value
    }

    @JvmName("dhfacurrdtxouyrr")
    public suspend fun alertGroups(vararg values: Output<String>) {
        this.alertGroups = Output.all(values.asList())
    }

    /**
     * @param values The alert group.
     */
    @JvmName("ssyipehomwvkmrlx")
    public suspend fun alertGroups(values: List<Output<String>>) {
        this.alertGroups = Output.all(values)
    }

    /**
     * @param value The access type of the CNAME domain name. Valid value: `PUBLIC`.
     */
    @JvmName("otprurcytoiaeedy")
    public suspend fun cnameType(`value`: Output<String>) {
        this.cnameType = value
    }

    /**
     * @param value The force update.
     */
    @JvmName("uhrexxnxesnjjnau")
    public suspend fun forceUpdate(`value`: Output<Boolean>) {
        this.forceUpdate = value
    }

    /**
     * @param value The quota of detection tasks.
     */
    @JvmName("rjppqamtlbkeycsr")
    public suspend fun healthCheckTaskCount(`value`: Output<Int>) {
        this.healthCheckTaskCount = value
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("hplkbiyquhclgjik")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The lang.
     */
    @JvmName("nwuidkhdhhlqqhxy")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value Paid package version. Valid values: `ultimate`, `standard`.
     */
    @JvmName("syrqxpsbvryfqnqy")
    public suspend fun packageEdition(`value`: Output<String>) {
        this.packageEdition = value
    }

    /**
     * @param value The Payment Type of the resource. Valid value: `Subscription`.
     */
    @JvmName("mdhtyjbsqvjhmmtn")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("bbckevbxwbwtcknl")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
     */
    @JvmName("lmotlquhciccnveg")
    public suspend fun publicCnameMode(`value`: Output<String>) {
        this.publicCnameMode = value
    }

    /**
     * @param value The CNAME access domain name.
     */
    @JvmName("muhpcimrovyxbrlp")
    public suspend fun publicRr(`value`: Output<String>) {
        this.publicRr = value
    }

    /**
     * @param value The website domain name that the user uses on the Internet.
     */
    @JvmName("mwmdqktkvycbxmtr")
    public suspend fun publicUserDomainName(`value`: Output<String>) {
        this.publicUserDomainName = value
    }

    /**
     * @param value The domain name that is used to access GTM over the Internet.
     */
    @JvmName("gqnfariasparavqv")
    public suspend fun publicZoneName(`value`: Output<String>) {
        this.publicZoneName = value
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
     */
    @JvmName("yrtapjyxjhpfjrhe")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    @JvmName("kswysfgkvavpjimd")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vtunckxxewiemmvw")
    public suspend fun resourceGroupId(`value`: Output<String>) {
        this.resourceGroupId = value
    }

    /**
     * @param value The quota of SMS notifications.
     */
    @JvmName("rnbcfgvjpqssaaee")
    public suspend fun smsNotificationCount(`value`: Output<Int>) {
        this.smsNotificationCount = value
    }

    /**
     * @param value The type of the access policy. Valid values: `GEO`, `LATENCY`.
     */
    @JvmName("wvxndvfwhnbpkmuo")
    public suspend fun strategyMode(`value`: Output<String>) {
        this.strategyMode = value
    }

    /**
     * @param value The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
     */
    @JvmName("hdfsssstufityttj")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("wqwqvshsfqdmiuer")
    public suspend fun alertConfigs(`value`: List<GtmInstanceAlertConfigArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("jmfbbmqxmwdbgdgi")
    public suspend fun alertConfigs(argument: List<suspend GtmInstanceAlertConfigArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            GtmInstanceAlertConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("itbruhmidgiuqqdl")
    public suspend fun alertConfigs(vararg argument: suspend GtmInstanceAlertConfigArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            GtmInstanceAlertConfigArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param argument The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("xqawburmxwruccbb")
    public suspend fun alertConfigs(argument: suspend GtmInstanceAlertConfigArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(GtmInstanceAlertConfigArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.alertConfigs = mapped
    }

    /**
     * @param values The alert notification methods. See `alert_config` below for details.
     */
    @JvmName("ccpbthrreuctjhpm")
    public suspend fun alertConfigs(vararg values: GtmInstanceAlertConfigArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertConfigs = mapped
    }

    /**
     * @param value The alert group.
     */
    @JvmName("cehxvoswngbacgex")
    public suspend fun alertGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alertGroups = mapped
    }

    /**
     * @param values The alert group.
     */
    @JvmName("jdbebynmciqxdohi")
    public suspend fun alertGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.alertGroups = mapped
    }

    /**
     * @param value The access type of the CNAME domain name. Valid value: `PUBLIC`.
     */
    @JvmName("lhmpbterixmxvafr")
    public suspend fun cnameType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cnameType = mapped
    }

    /**
     * @param value The force update.
     */
    @JvmName("vjjbgnvlkdrfyyyx")
    public suspend fun forceUpdate(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forceUpdate = mapped
    }

    /**
     * @param value The quota of detection tasks.
     */
    @JvmName("btmoottdxvrnjdxq")
    public suspend fun healthCheckTaskCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckTaskCount = mapped
    }

    /**
     * @param value The name of the instance.
     */
    @JvmName("umuitmgyyhgrjbdd")
    public suspend fun instanceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("thvcmkanebuamrmg")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value Paid package version. Valid values: `ultimate`, `standard`.
     */
    @JvmName("igyurgcvabhkxkgp")
    public suspend fun packageEdition(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageEdition = mapped
    }

    /**
     * @param value The Payment Type of the resource. Valid value: `Subscription`.
     */
    @JvmName("jwvttgoyghodrfui")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("cmthmmaxbimvqgad")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value The Public Network domain name access method. Valid values: `CUSTOM`, `SYSTEM_ASSIGN`.
     */
    @JvmName("ekkmctioncrcqwfc")
    public suspend fun publicCnameMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicCnameMode = mapped
    }

    /**
     * @param value The CNAME access domain name.
     */
    @JvmName("cjsnfwequxrgxiax")
    public suspend fun publicRr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicRr = mapped
    }

    /**
     * @param value The website domain name that the user uses on the Internet.
     */
    @JvmName("scettwbadxmfofin")
    public suspend fun publicUserDomainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicUserDomainName = mapped
    }

    /**
     * @param value The domain name that is used to access GTM over the Internet.
     */
    @JvmName("gyjnfhsxceelgdhg")
    public suspend fun publicZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicZoneName = mapped
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting `renewal_status` to AutoRenewal, it must be set.
     */
    @JvmName("wwaerkvxmpjalgfd")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`.
     */
    @JvmName("rmspieycjjndiaeg")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("jqxibpwsgqyxtgba")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupId = mapped
    }

    /**
     * @param value The quota of SMS notifications.
     */
    @JvmName("xgyrpgmrwjexflsr")
    public suspend fun smsNotificationCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsNotificationCount = mapped
    }

    /**
     * @param value The type of the access policy. Valid values: `GEO`, `LATENCY`.
     */
    @JvmName("ikfgfknosjfpxflf")
    public suspend fun strategyMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.strategyMode = mapped
    }

    /**
     * @param value The global time to live. Valid values: `60`, `120`, `300`, `600`. Unit: second.
     */
    @JvmName("xivtgpnxclgakqra")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    internal fun build(): GtmInstanceArgs = GtmInstanceArgs(
        alertConfigs = alertConfigs,
        alertGroups = alertGroups,
        cnameType = cnameType,
        forceUpdate = forceUpdate,
        healthCheckTaskCount = healthCheckTaskCount,
        instanceName = instanceName,
        lang = lang,
        packageEdition = packageEdition,
        paymentType = paymentType,
        period = period,
        publicCnameMode = publicCnameMode,
        publicRr = publicRr,
        publicUserDomainName = publicUserDomainName,
        publicZoneName = publicZoneName,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
        resourceGroupId = resourceGroupId,
        smsNotificationCount = smsNotificationCount,
        strategyMode = strategyMode,
        ttl = ttl,
    )
}
