@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.InstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Create an DNS Instance resource.
 * > **DEPRECATED:** This resource has been renamed to alicloud.dns.AlidnsInstance from version 1.95.0.
 * > **NOTE:** Available in v1.80.0+.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const _this = new alicloud.dns.Instance("this", {
 *     dnsSecurity: "no",
 *     domainNumbers: "2",
 *     period: 1,
 *     renewPeriod: 1,
 *     renewalStatus: "ManualRenewal",
 *     versionCode: "version_personal",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * this = alicloud.dns.Instance("this",
 *     dns_security="no",
 *     domain_numbers="2",
 *     period=1,
 *     renew_period=1,
 *     renewal_status="ManualRenewal",
 *     version_code="version_personal")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var @this = new AliCloud.Dns.Instance("this", new()
 *     {
 *         DnsSecurity = "no",
 *         DomainNumbers = "2",
 *         Period = 1,
 *         RenewPeriod = 1,
 *         RenewalStatus = "ManualRenewal",
 *         VersionCode = "version_personal",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := dns.NewInstance(ctx, "this", &dns.InstanceArgs{
 * 			DnsSecurity:   pulumi.String("no"),
 * 			DomainNumbers: pulumi.String("2"),
 * 			Period:        pulumi.Int(1),
 * 			RenewPeriod:   pulumi.Int(1),
 * 			RenewalStatus: pulumi.String("ManualRenewal"),
 * 			VersionCode:   pulumi.String("version_personal"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Instance;
 * import com.pulumi.alicloud.dns.InstanceArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var this_ = new Instance("this", InstanceArgs.builder()
 *             .dnsSecurity("no")
 *             .domainNumbers("2")
 *             .period(1)
 *             .renewPeriod(1)
 *             .renewalStatus("ManualRenewal")
 *             .versionCode("version_personal")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   this:
 *     type: alicloud:dns:Instance
 *     properties:
 *       dnsSecurity: no
 *       domainNumbers: '2'
 *       period: 1
 *       renewPeriod: 1
 *       renewalStatus: ManualRenewal
 *       versionCode: version_personal
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS instance be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/instance:Instance example dns-cn-v0h1ldjhfff
 * ```
 * @property dnsSecurity DNS security level. Valid values: `no`, `basic`, `advanced`.
 * @property domainNumbers Number of domain names bound.
 * @property paymentType
 * @property period Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
 * @property renewPeriod Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
 * @property renewalStatus Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
 * @property versionCode Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
 */
public data class InstanceArgs(
    public val dnsSecurity: Output<String>? = null,
    public val domainNumbers: Output<String>? = null,
    public val paymentType: Output<String>? = null,
    public val period: Output<Int>? = null,
    public val renewPeriod: Output<Int>? = null,
    public val renewalStatus: Output<String>? = null,
    public val versionCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.InstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.InstanceArgs =
        com.pulumi.alicloud.dns.InstanceArgs.builder()
            .dnsSecurity(dnsSecurity?.applyValue({ args0 -> args0 }))
            .domainNumbers(domainNumbers?.applyValue({ args0 -> args0 }))
            .paymentType(paymentType?.applyValue({ args0 -> args0 }))
            .period(period?.applyValue({ args0 -> args0 }))
            .renewPeriod(renewPeriod?.applyValue({ args0 -> args0 }))
            .renewalStatus(renewalStatus?.applyValue({ args0 -> args0 }))
            .versionCode(versionCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InstanceArgs].
 */
@PulumiTagMarker
public class InstanceArgsBuilder internal constructor() {
    private var dnsSecurity: Output<String>? = null

    private var domainNumbers: Output<String>? = null

    private var paymentType: Output<String>? = null

    private var period: Output<Int>? = null

    private var renewPeriod: Output<Int>? = null

    private var renewalStatus: Output<String>? = null

    private var versionCode: Output<String>? = null

    /**
     * @param value DNS security level. Valid values: `no`, `basic`, `advanced`.
     */
    @JvmName("ntqwocjcitrpahky")
    public suspend fun dnsSecurity(`value`: Output<String>) {
        this.dnsSecurity = value
    }

    /**
     * @param value Number of domain names bound.
     */
    @JvmName("lvkxofxlqhcxyhip")
    public suspend fun domainNumbers(`value`: Output<String>) {
        this.domainNumbers = value
    }

    /**
     * @param value
     */
    @JvmName("mrerpfnalkyskfqj")
    public suspend fun paymentType(`value`: Output<String>) {
        this.paymentType = value
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("ndutipcaalmsuvjl")
    public suspend fun period(`value`: Output<Int>) {
        this.period = value
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
     */
    @JvmName("jmijioylcxihotty")
    public suspend fun renewPeriod(`value`: Output<Int>) {
        this.renewPeriod = value
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
     */
    @JvmName("lgbwurivavwnefgu")
    public suspend fun renewalStatus(`value`: Output<String>) {
        this.renewalStatus = value
    }

    /**
     * @param value Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
     */
    @JvmName("wfesfpanjcqxedoh")
    public suspend fun versionCode(`value`: Output<String>) {
        this.versionCode = value
    }

    /**
     * @param value DNS security level. Valid values: `no`, `basic`, `advanced`.
     */
    @JvmName("rkvdulkxaiujkcto")
    public suspend fun dnsSecurity(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsSecurity = mapped
    }

    /**
     * @param value Number of domain names bound.
     */
    @JvmName("twxcygpbuyquusde")
    public suspend fun domainNumbers(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainNumbers = mapped
    }

    /**
     * @param value
     */
    @JvmName("xyjaxngbssqnypav")
    public suspend fun paymentType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.paymentType = mapped
    }

    /**
     * @param value Creating a pre-paid instance, it must be set, the unit is month, please enter an integer multiple of 12 for annually paid products.
     */
    @JvmName("vnmdibyewdlqqqao")
    public suspend fun period(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.period = mapped
    }

    /**
     * @param value Automatic renewal period, the unit is month. When setting RenewalStatus to AutoRenewal, it must be set.
     */
    @JvmName("lvrnxrmwhjlvxxnj")
    public suspend fun renewPeriod(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewPeriod = mapped
    }

    /**
     * @param value Automatic renewal status. Valid values: `AutoRenewal`, `ManualRenewal`, default to `ManualRenewal`.
     */
    @JvmName("rtbylvhdxurfpioo")
    public suspend fun renewalStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.renewalStatus = mapped
    }

    /**
     * @param value Paid package version. Valid values: `version_personal`, `version_enterprise_basic`, `version_enterprise_advanced`.
     */
    @JvmName("sbrywxqjhladhsfy")
    public suspend fun versionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.versionCode = mapped
    }

    internal fun build(): InstanceArgs = InstanceArgs(
        dnsSecurity = dnsSecurity,
        domainNumbers = domainNumbers,
        paymentType = paymentType,
        period = period,
        renewPeriod = renewPeriod,
        renewalStatus = renewalStatus,
        versionCode = versionCode,
    )
}
