@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.MonitorConfigArgs.builder
import com.pulumi.alicloud.dns.kotlin.inputs.MonitorConfigIspCityNodeArgs
import com.pulumi.alicloud.dns.kotlin.inputs.MonitorConfigIspCityNodeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides a DNS Monitor Config resource.
 * For information about DNS Monitor Config and how to use it, see [What is Monitor Config](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/api-alidns-2015-01-09-adddnsgtmmonitor).
 * > **NOTE:** Available since v1.153.0.
 * ## Example Usage
 * Basic Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * const config = new pulumi.Config();
 * const name = config.get("name") || "tf_example";
 * const domainName = config.get("domainName") || "alicloud-provider.com";
 * const default = alicloud.resourcemanager.getResourceGroups({});
 * const defaultAlarmContactGroup = new alicloud.cms.AlarmContactGroup("default", {alarmContactGroupName: name});
 * const defaultGtmInstance = new alicloud.dns.GtmInstance("default", {
 *     instanceName: name,
 *     paymentType: "Subscription",
 *     period: 1,
 *     renewalStatus: "ManualRenewal",
 *     packageEdition: "standard",
 *     healthCheckTaskCount: 100,
 *     smsNotificationCount: 1000,
 *     publicCnameMode: "SYSTEM_ASSIGN",
 *     ttl: 60,
 *     cnameType: "PUBLIC",
 *     resourceGroupId: _default.then(_default => _default.groups?.[0]?.id),
 *     alertGroups: [defaultAlarmContactGroup&#46;alarmContactGroupName],
 *     publicUserDomainName: domainName,
 *     alertConfigs: [{
 *         smsNotice: true,
 *         noticeType: "ADDR_ALERT",
 *         emailNotice: true,
 *         dingtalkNotice: true,
 *     }],
 * });
 * const defaultAddressPool = new alicloud.dns.AddressPool("default", {
 *     addressPoolName: name,
 *     instanceId: defaultGtmInstance.id,
 *     lbaStrategy: "RATIO",
 *     type: "IPV4",
 *     addresses: [{
 *         attributeInfo: "{\"lineCodeRectifyType\":\"RECTIFIED\",\"lineCodes\":[\"os_namerica_us\"]}",
 *         remark: "address_remark",
 *         address: "1.1.1.1",
 *         mode: "SMART",
 *         lbaWeight: 1,
 *     }],
 * });
 * const defaultMonitorConfig = new alicloud.dns.MonitorConfig("default", {
 *     addrPoolId: defaultAddressPool.id,
 *     evaluationCount: 1,
 *     interval: 60,
 *     timeout: 5000,
 *     protocolType: "TCP",
 *     monitorExtendInfo: "{\"failureRate\":50,\"port\":80}",
 *     ispCityNodes: [{
 *         cityCode: "503",
 *         ispCode: "465",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * config = pulumi.Config()
 * name = config.get("name")
 * if name is None:
 *     name = "tf_example"
 * domain_name = config.get("domainName")
 * if domain_name is None:
 *     domain_name = "alicloud-provider.com"
 * default = alicloud.resourcemanager.get_resource_groups()
 * default_alarm_contact_group = alicloud.cms.AlarmContactGroup("default", alarm_contact_group_name=name)
 * default_gtm_instance = alicloud.dns.GtmInstance("default",
 *     instance_name=name,
 *     payment_type="Subscription",
 *     period=1,
 *     renewal_status="ManualRenewal",
 *     package_edition="standard",
 *     health_check_task_count=100,
 *     sms_notification_count=1000,
 *     public_cname_mode="SYSTEM_ASSIGN",
 *     ttl=60,
 *     cname_type="PUBLIC",
 *     resource_group_id=default.groups[0].id,
 *     alert_groups=[default_alarm_contact_group&#46;alarm_contact_group_name],
 *     public_user_domain_name=domain_name,
 *     alert_configs=[{
 *         "sms_notice": True,
 *         "notice_type": "ADDR_ALERT",
 *         "email_notice": True,
 *         "dingtalk_notice": True,
 *     }])
 * default_address_pool = alicloud.dns.AddressPool("default",
 *     address_pool_name=name,
 *     instance_id=default_gtm_instance.id,
 *     lba_strategy="RATIO",
 *     type="IPV4",
 *     addresses=[{
 *         "attribute_info": "{\"lineCodeRectifyType\":\"RECTIFIED\",\"lineCodes\":[\"os_namerica_us\"]}",
 *         "remark": "address_remark",
 *         "address": "1.1.1.1",
 *         "mode": "SMART",
 *         "lba_weight": 1,
 *     }])
 * default_monitor_config = alicloud.dns.MonitorConfig("default",
 *     addr_pool_id=default_address_pool.id,
 *     evaluation_count=1,
 *     interval=60,
 *     timeout=5000,
 *     protocol_type="TCP",
 *     monitor_extend_info="{\"failureRate\":50,\"port\":80}",
 *     isp_city_nodes=[{
 *         "city_code": "503",
 *         "isp_code": "465",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     var config = new Config();
 *     var name = config.Get("name") ?? "tf_example";
 *     var domainName = config.Get("domainName") ?? "alicloud-provider.com";
 *     var @default = AliCloud.ResourceManager.GetResourceGroups.Invoke();
 *     var defaultAlarmContactGroup = new AliCloud.Cms.AlarmContactGroup("default", new()
 *     {
 *         AlarmContactGroupName = name,
 *     });
 *     var defaultGtmInstance = new AliCloud.Dns.GtmInstance("default", new()
 *     {
 *         InstanceName = name,
 *         PaymentType = "Subscription",
 *         Period = 1,
 *         RenewalStatus = "ManualRenewal",
 *         PackageEdition = "standard",
 *         HealthCheckTaskCount = 100,
 *         SmsNotificationCount = 1000,
 *         PublicCnameMode = "SYSTEM_ASSIGN",
 *         Ttl = 60,
 *         CnameType = "PUBLIC",
 *         ResourceGroupId = @default.Apply(@default => @default.Apply(getResourceGroupsResult => getResourceGroupsResult.Groups[0]?.Id)),
 *         AlertGroups = new[]
 *         {
 *             defaultAlarmContactGroup.AlarmContactGroupName,
 *         },
 *         PublicUserDomainName = domainName,
 *         AlertConfigs = new[]
 *         {
 *             new AliCloud.Dns.Inputs.GtmInstanceAlertConfigArgs
 *             {
 *                 SmsNotice = true,
 *                 NoticeType = "ADDR_ALERT",
 *                 EmailNotice = true,
 *                 DingtalkNotice = true,
 *             },
 *         },
 *     });
 *     var defaultAddressPool = new AliCloud.Dns.AddressPool("default", new()
 *     {
 *         AddressPoolName = name,
 *         InstanceId = defaultGtmInstance.Id,
 *         LbaStrategy = "RATIO",
 *         Type = "IPV4",
 *         Addresses = new[]
 *         {
 *             new AliCloud.Dns.Inputs.AddressPoolAddressArgs
 *             {
 *                 AttributeInfo = "{\"lineCodeRectifyType\":\"RECTIFIED\",\"lineCodes\":[\"os_namerica_us\"]}",
 *                 Remark = "address_remark",
 *                 Address = "1.1.1.1",
 *                 Mode = "SMART",
 *                 LbaWeight = 1,
 *             },
 *         },
 *     });
 *     var defaultMonitorConfig = new AliCloud.Dns.MonitorConfig("default", new()
 *     {
 *         AddrPoolId = defaultAddressPool.Id,
 *         EvaluationCount = 1,
 *         Interval = 60,
 *         Timeout = 5000,
 *         ProtocolType = "TCP",
 *         MonitorExtendInfo = "{\"failureRate\":50,\"port\":80}",
 *         IspCityNodes = new[]
 *         {
 *             new AliCloud.Dns.Inputs.MonitorConfigIspCityNodeArgs
 *             {
 *                 CityCode = "503",
 *                 IspCode = "465",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/cms"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/resourcemanager"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi/config"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		cfg := config.New(ctx, "")
 * 		name := "tf_example"
 * 		if param := cfg.Get("name"); param != "" {
 * 			name = param
 * 		}
 * 		domainName := "alicloud-provider.com"
 * 		if param := cfg.Get("domainName"); param != "" {
 * 			domainName = param
 * 		}
 * 		_default, err := resourcemanager.GetResourceGroups(ctx, nil, nil)
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAlarmContactGroup, err := cms.NewAlarmContactGroup(ctx, "default", &cms.AlarmContactGroupArgs{
 * 			AlarmContactGroupName: pulumi.String(name),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultGtmInstance, err := dns.NewGtmInstance(ctx, "default", &dns.GtmInstanceArgs{
 * 			InstanceName:         pulumi.String(name),
 * 			PaymentType:          pulumi.String("Subscription"),
 * 			Period:               pulumi.Int(1),
 * 			RenewalStatus:        pulumi.String("ManualRenewal"),
 * 			PackageEdition:       pulumi.String("standard"),
 * 			HealthCheckTaskCount: pulumi.Int(100),
 * 			SmsNotificationCount: pulumi.Int(1000),
 * 			PublicCnameMode:      pulumi.String("SYSTEM_ASSIGN"),
 * 			Ttl:                  pulumi.Int(60),
 * 			CnameType:            pulumi.String("PUBLIC"),
 * 			ResourceGroupId:      pulumi.String(_default.Groups[0].Id),
 * 			AlertGroups: pulumi.StringArray{
 * 				defaultAlarmContactGroup.AlarmContactGroupName,
 * 			},
 * 			PublicUserDomainName: pulumi.String(domainName),
 * 			AlertConfigs: dns.GtmInstanceAlertConfigArray{
 * 				&dns.GtmInstanceAlertConfigArgs{
 * 					SmsNotice:      pulumi.Bool(true),
 * 					NoticeType:     pulumi.String("ADDR_ALERT"),
 * 					EmailNotice:    pulumi.Bool(true),
 * 					DingtalkNotice: pulumi.Bool(true),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		defaultAddressPool, err := dns.NewAddressPool(ctx, "default", &dns.AddressPoolArgs{
 * 			AddressPoolName: pulumi.String(name),
 * 			InstanceId:      defaultGtmInstance.ID(),
 * 			LbaStrategy:     pulumi.String("RATIO"),
 * 			Type:            pulumi.String("IPV4"),
 * 			Addresses: dns.AddressPoolAddressArray{
 * 				&dns.AddressPoolAddressArgs{
 * 					AttributeInfo: pulumi.String("{\"lineCodeRectifyType\":\"RECTIFIED\",\"lineCodes\":[\"os_namerica_us\"]}"),
 * 					Remark:        pulumi.String("address_remark"),
 * 					Address:       pulumi.String("1.1.1.1"),
 * 					Mode:          pulumi.String("SMART"),
 * 					LbaWeight:     pulumi.Int(1),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = dns.NewMonitorConfig(ctx, "default", &dns.MonitorConfigArgs{
 * 			AddrPoolId:        defaultAddressPool.ID(),
 * 			EvaluationCount:   pulumi.Int(1),
 * 			Interval:          pulumi.Int(60),
 * 			Timeout:           pulumi.Int(5000),
 * 			ProtocolType:      pulumi.String("TCP"),
 * 			MonitorExtendInfo: pulumi.String("{\"failureRate\":50,\"port\":80}"),
 * 			IspCityNodes: dns.MonitorConfigIspCityNodeArray{
 * 				&dns.MonitorConfigIspCityNodeArgs{
 * 					CityCode: pulumi.String("503"),
 * 					IspCode:  pulumi.String("465"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.resourcemanager.ResourcemanagerFunctions;
 * import com.pulumi.alicloud.resourcemanager.inputs.GetResourceGroupsArgs;
 * import com.pulumi.alicloud.cms.AlarmContactGroup;
 * import com.pulumi.alicloud.cms.AlarmContactGroupArgs;
 * import com.pulumi.alicloud.dns.GtmInstance;
 * import com.pulumi.alicloud.dns.GtmInstanceArgs;
 * import com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs;
 * import com.pulumi.alicloud.dns.AddressPool;
 * import com.pulumi.alicloud.dns.AddressPoolArgs;
 * import com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs;
 * import com.pulumi.alicloud.dns.MonitorConfig;
 * import com.pulumi.alicloud.dns.MonitorConfigArgs;
 * import com.pulumi.alicloud.dns.inputs.MonitorConfigIspCityNodeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var config = ctx.config();
 *         final var name = config.get("name").orElse("tf_example");
 *         final var domainName = config.get("domainName").orElse("alicloud-provider.com");
 *         final var default = ResourcemanagerFunctions.getResourceGroups();
 *         var defaultAlarmContactGroup = new AlarmContactGroup("defaultAlarmContactGroup", AlarmContactGroupArgs.builder()
 *             .alarmContactGroupName(name)
 *             .build());
 *         var defaultGtmInstance = new GtmInstance("defaultGtmInstance", GtmInstanceArgs.builder()
 *             .instanceName(name)
 *             .paymentType("Subscription")
 *             .period(1)
 *             .renewalStatus("ManualRenewal")
 *             .packageEdition("standard")
 *             .healthCheckTaskCount(100)
 *             .smsNotificationCount(1000)
 *             .publicCnameMode("SYSTEM_ASSIGN")
 *             .ttl(60)
 *             .cnameType("PUBLIC")
 *             .resourceGroupId(default_.groups()[0].id())
 *             .alertGroups(defaultAlarmContactGroup.alarmContactGroupName())
 *             .publicUserDomainName(domainName)
 *             .alertConfigs(GtmInstanceAlertConfigArgs.builder()
 *                 .smsNotice(true)
 *                 .noticeType("ADDR_ALERT")
 *                 .emailNotice(true)
 *                 .dingtalkNotice(true)
 *                 .build())
 *             .build());
 *         var defaultAddressPool = new AddressPool("defaultAddressPool", AddressPoolArgs.builder()
 *             .addressPoolName(name)
 *             .instanceId(defaultGtmInstance.id())
 *             .lbaStrategy("RATIO")
 *             .type("IPV4")
 *             .addresses(AddressPoolAddressArgs.builder()
 *                 .attributeInfo("{\"lineCodeRectifyType\":\"RECTIFIED\",\"lineCodes\":[\"os_namerica_us\"]}")
 *                 .remark("address_remark")
 *                 .address("1.1.1.1")
 *                 .mode("SMART")
 *                 .lbaWeight(1)
 *                 .build())
 *             .build());
 *         var defaultMonitorConfig = new MonitorConfig("defaultMonitorConfig", MonitorConfigArgs.builder()
 *             .addrPoolId(defaultAddressPool.id())
 *             .evaluationCount("1")
 *             .interval("60")
 *             .timeout("5000")
 *             .protocolType("TCP")
 *             .monitorExtendInfo("{\"failureRate\":50,\"port\":80}")
 *             .ispCityNodes(MonitorConfigIspCityNodeArgs.builder()
 *                 .cityCode("503")
 *                 .ispCode("465")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * configuration:
 *   name:
 *     type: string
 *     default: tf_example
 *   domainName:
 *     type: string
 *     default: alicloud-provider.com
 * resources:
 *   defaultAlarmContactGroup:
 *     type: alicloud:cms:AlarmContactGroup
 *     name: default
 *     properties:
 *       alarmContactGroupName: ${name}
 *   defaultGtmInstance:
 *     type: alicloud:dns:GtmInstance
 *     name: default
 *     properties:
 *       instanceName: ${name}
 *       paymentType: Subscription
 *       period: 1
 *       renewalStatus: ManualRenewal
 *       packageEdition: standard
 *       healthCheckTaskCount: 100
 *       smsNotificationCount: 1000
 *       publicCnameMode: SYSTEM_ASSIGN
 *       ttl: 60
 *       cnameType: PUBLIC
 *       resourceGroupId: ${default.groups[0].id}
 *       alertGroups:
 *         - ${defaultAlarmContactGroup.alarmContactGroupName}
 *       publicUserDomainName: ${domainName}
 *       alertConfigs:
 *         - smsNotice: true
 *           noticeType: ADDR_ALERT
 *           emailNotice: true
 *           dingtalkNotice: true
 *   defaultAddressPool:
 *     type: alicloud:dns:AddressPool
 *     name: default
 *     properties:
 *       addressPoolName: ${name}
 *       instanceId: ${defaultGtmInstance.id}
 *       lbaStrategy: RATIO
 *       type: IPV4
 *       addresses:
 *         - attributeInfo: '{"lineCodeRectifyType":"RECTIFIED","lineCodes":["os_namerica_us"]}'
 *           remark: address_remark
 *           address: 1.1.1.1
 *           mode: SMART
 *           lbaWeight: 1
 *   defaultMonitorConfig:
 *     type: alicloud:dns:MonitorConfig
 *     name: default
 *     properties:
 *       addrPoolId: ${defaultAddressPool.id}
 *       evaluationCount: '1'
 *       interval: '60'
 *       timeout: '5000'
 *       protocolType: TCP
 *       monitorExtendInfo: '{"failureRate":50,"port":80}'
 *       ispCityNodes:
 *         - cityCode: '503'
 *           ispCode: '465'
 * variables:
 *   default:
 *     fn::invoke:
 *       Function: alicloud:resourcemanager:getResourceGroups
 *       Arguments: {}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * DNS Monitor Config can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/monitorConfig:MonitorConfig example <id>
 * ```
 * @property addrPoolId The ID of the address pool.
 * @property evaluationCount The number of consecutive times of failed health check attempts. Valid values: `1`, `2`, `3`.
 * @property interval The health check interval. Unit: seconds. Valid values: `60`.
 * @property ispCityNodes The Monitoring node. See `isp_city_node` below for details.
 * @property lang The lang.
 * @property monitorExtendInfo The extended information. This value follows the json format. For more details, see the [description of MonitorExtendInfo in the Request parameters table for details](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/api-alidns-2015-01-09-adddnsgtmmonitor).
 * @property protocolType The health check protocol. Valid values: `HTTP`, `HTTPS`, `PING`, `TCP`.
 * @property timeout The timeout period. Unit: milliseconds. Valid values: `2000`, `3000`, `5000`, `10000`.
 */
public data class MonitorConfigArgs(
    public val addrPoolId: Output<String>? = null,
    public val evaluationCount: Output<Int>? = null,
    public val interval: Output<Int>? = null,
    public val ispCityNodes: Output<List<MonitorConfigIspCityNodeArgs>>? = null,
    public val lang: Output<String>? = null,
    public val monitorExtendInfo: Output<String>? = null,
    public val protocolType: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.MonitorConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.MonitorConfigArgs =
        com.pulumi.alicloud.dns.MonitorConfigArgs.builder()
            .addrPoolId(addrPoolId?.applyValue({ args0 -> args0 }))
            .evaluationCount(evaluationCount?.applyValue({ args0 -> args0 }))
            .interval(interval?.applyValue({ args0 -> args0 }))
            .ispCityNodes(
                ispCityNodes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .lang(lang?.applyValue({ args0 -> args0 }))
            .monitorExtendInfo(monitorExtendInfo?.applyValue({ args0 -> args0 }))
            .protocolType(protocolType?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorConfigArgs].
 */
@PulumiTagMarker
public class MonitorConfigArgsBuilder internal constructor() {
    private var addrPoolId: Output<String>? = null

    private var evaluationCount: Output<Int>? = null

    private var interval: Output<Int>? = null

    private var ispCityNodes: Output<List<MonitorConfigIspCityNodeArgs>>? = null

    private var lang: Output<String>? = null

    private var monitorExtendInfo: Output<String>? = null

    private var protocolType: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value The ID of the address pool.
     */
    @JvmName("yqwulukrdkoilotl")
    public suspend fun addrPoolId(`value`: Output<String>) {
        this.addrPoolId = value
    }

    /**
     * @param value The number of consecutive times of failed health check attempts. Valid values: `1`, `2`, `3`.
     */
    @JvmName("gwwdynyrkomsjpqp")
    public suspend fun evaluationCount(`value`: Output<Int>) {
        this.evaluationCount = value
    }

    /**
     * @param value The health check interval. Unit: seconds. Valid values: `60`.
     */
    @JvmName("rjjauqmrlqcmfnyg")
    public suspend fun interval(`value`: Output<Int>) {
        this.interval = value
    }

    /**
     * @param value The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("fidrtmtwogyfjdgy")
    public suspend fun ispCityNodes(`value`: Output<List<MonitorConfigIspCityNodeArgs>>) {
        this.ispCityNodes = value
    }

    @JvmName("ebcvedegnejdoval")
    public suspend fun ispCityNodes(vararg values: Output<MonitorConfigIspCityNodeArgs>) {
        this.ispCityNodes = Output.all(values.asList())
    }

    /**
     * @param values The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("brndpxenrjxhstyx")
    public suspend fun ispCityNodes(values: List<Output<MonitorConfigIspCityNodeArgs>>) {
        this.ispCityNodes = Output.all(values)
    }

    /**
     * @param value The lang.
     */
    @JvmName("bmbaawriafanuwcb")
    public suspend fun lang(`value`: Output<String>) {
        this.lang = value
    }

    /**
     * @param value The extended information. This value follows the json format. For more details, see the [description of MonitorExtendInfo in the Request parameters table for details](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/api-alidns-2015-01-09-adddnsgtmmonitor).
     */
    @JvmName("jalmcjvxvoevtwog")
    public suspend fun monitorExtendInfo(`value`: Output<String>) {
        this.monitorExtendInfo = value
    }

    /**
     * @param value The health check protocol. Valid values: `HTTP`, `HTTPS`, `PING`, `TCP`.
     */
    @JvmName("qkvjwyhypdtgnyde")
    public suspend fun protocolType(`value`: Output<String>) {
        this.protocolType = value
    }

    /**
     * @param value The timeout period. Unit: milliseconds. Valid values: `2000`, `3000`, `5000`, `10000`.
     */
    @JvmName("gnmvwaulakqnnstt")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value The ID of the address pool.
     */
    @JvmName("erqxocwsxhiakgir")
    public suspend fun addrPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addrPoolId = mapped
    }

    /**
     * @param value The number of consecutive times of failed health check attempts. Valid values: `1`, `2`, `3`.
     */
    @JvmName("tmnvybpymrstlkrn")
    public suspend fun evaluationCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.evaluationCount = mapped
    }

    /**
     * @param value The health check interval. Unit: seconds. Valid values: `60`.
     */
    @JvmName("ttsuanhhqknixiqk")
    public suspend fun interval(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.interval = mapped
    }

    /**
     * @param value The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("vidgmgccauowaihw")
    public suspend fun ispCityNodes(`value`: List<MonitorConfigIspCityNodeArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ispCityNodes = mapped
    }

    /**
     * @param argument The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("bcdilvqwycatilvi")
    public suspend fun ispCityNodes(argument: List<suspend MonitorConfigIspCityNodeArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MonitorConfigIspCityNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ispCityNodes = mapped
    }

    /**
     * @param argument The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("cjrivfsrirvslcjh")
    public suspend fun ispCityNodes(vararg argument: suspend MonitorConfigIspCityNodeArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            MonitorConfigIspCityNodeArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ispCityNodes = mapped
    }

    /**
     * @param argument The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("ekttuaormguomwme")
    public suspend fun ispCityNodes(argument: suspend MonitorConfigIspCityNodeArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MonitorConfigIspCityNodeArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ispCityNodes = mapped
    }

    /**
     * @param values The Monitoring node. See `isp_city_node` below for details.
     */
    @JvmName("mafwrotwnvksvawh")
    public suspend fun ispCityNodes(vararg values: MonitorConfigIspCityNodeArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ispCityNodes = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("hwgkerradsmbbvbn")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lang = mapped
    }

    /**
     * @param value The extended information. This value follows the json format. For more details, see the [description of MonitorExtendInfo in the Request parameters table for details](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/api-alidns-2015-01-09-adddnsgtmmonitor).
     */
    @JvmName("jvwosjkvdoduqkmt")
    public suspend fun monitorExtendInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitorExtendInfo = mapped
    }

    /**
     * @param value The health check protocol. Valid values: `HTTP`, `HTTPS`, `PING`, `TCP`.
     */
    @JvmName("udivaeuxwaahvuwy")
    public suspend fun protocolType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protocolType = mapped
    }

    /**
     * @param value The timeout period. Unit: milliseconds. Valid values: `2000`, `3000`, `5000`, `10000`.
     */
    @JvmName("vbgcxftariwrrshu")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): MonitorConfigArgs = MonitorConfigArgs(
        addrPoolId = addrPoolId,
        evaluationCount = evaluationCount,
        interval = interval,
        ispCityNodes = ispCityNodes,
        lang = lang,
        monitorExtendInfo = monitorExtendInfo,
        protocolType = protocolType,
        timeout = timeout,
    )
}
