@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Record].
 */
@PulumiTagMarker
public class RecordResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: RecordArgs = RecordArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend RecordArgsBuilder.() -> Unit) {
        val builder = RecordArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Record {
        val builtJavaResource = com.pulumi.alicloud.dns.Record(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Record(builtJavaResource)
    }
}

/**
 * Provides a DNS Record resource.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.85.0`. Please use new resource alicloud_alidns_record.
 * > **NOTE:** When the site is an international site, the `type` neither supports `REDIRECT_URL` nor `REDIRECT_URL`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new Domain record
 * const record = new alicloud.dns.Record("record", {
 *     name: "domainname",
 *     hostRecord: "@",
 *     type: "A",
 *     value: "192.168.99.99",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new Domain record
 * record = alicloud.dns.Record("record",
 *     name="domainname",
 *     host_record="@",
 *     type="A",
 *     value="192.168.99.99")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new Domain record
 *     var record = new AliCloud.Dns.Record("record", new()
 *     {
 *         Name = "domainname",
 *         HostRecord = "@",
 *         Type = "A",
 *         Value = "192.168.99.99",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new Domain record
 * 		_, err := dns.NewRecord(ctx, "record", &dns.RecordArgs{
 * 			Name:       pulumi.String("domainname"),
 * 			HostRecord: pulumi.String("@"),
 * 			Type:       pulumi.String("A"),
 * 			Value:      pulumi.String("192.168.99.99"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Record;
 * import com.pulumi.alicloud.dns.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new Domain record
 *         var record = new Record("record", RecordArgs.builder()
 *             .name("domainname")
 *             .hostRecord("@")
 *             .type("A")
 *             .value("192.168.99.99")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new Domain record
 *   record:
 *     type: alicloud:dns:Record
 *     properties:
 *       name: domainname
 *       hostRecord: '@'
 *       type: A
 *       value: 192.168.99.99
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/record:Record example <id>
 * ```
 */
public class Record internal constructor(
    override val javaResource: com.pulumi.alicloud.dns.Record,
) : KotlinCustomResource(javaResource, RecordMapper) {
    /**
     * Host record for the domain record. This host_record can have at most 253 characters, and each part split with "." can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as "-",".","*","@",  and must not begin or end with "-".
     */
    public val hostRecord: Output<String>
        get() = javaResource.hostRecord().applyValue({ args0 -> args0 })

    public val locked: Output<Boolean>
        get() = javaResource.locked().applyValue({ args0 -> args0 })

    /**
     * Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The priority of domain record. Valid values are `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    public val priority: Output<Int>?
        get() = javaResource.priority().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The resolution line of domain record. Valid values are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/what-is-alibaba-cloud-dns) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    public val routing: Output<String>?
        get() = javaResource.routing().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The record status. `Enable` or `Disable`.
     * * `Locked` - The record locked state. `true` or `false`.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    public val ttl: Output<Int>?
        get() = javaResource.ttl().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The type of domain record. Valid values are `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    public val `value`: Output<String>
        get() = javaResource.`value`().applyValue({ args0 -> args0 })
}

public object RecordMapper : ResourceMapper<Record> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.alicloud.dns.Record::class == javaResource::class

    override fun map(javaResource: Resource): Record = Record(
        javaResource as
            com.pulumi.alicloud.dns.Record,
    )
}

/**
 * @see [Record].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Record].
 */
public suspend fun record(name: String, block: suspend RecordResourceBuilder.() -> Unit): Record {
    val builder = RecordResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Record].
 * @param name The _unique_ name of the resulting resource.
 */
public fun record(name: String): Record {
    val builder = RecordResourceBuilder()
    builder.name(name)
    return builder.build()
}
