@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin

import com.pulumi.alicloud.dns.RecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a DNS Record resource.
 * > **DEPRECATED:**  This resource  has been deprecated from version `1.85.0`. Please use new resource alicloud_alidns_record.
 * > **NOTE:** When the site is an international site, the `type` neither supports `REDIRECT_URL` nor `REDIRECT_URL`
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as alicloud from "@pulumi/alicloud";
 * // Create a new Domain record
 * const record = new alicloud.dns.Record("record", {
 *     name: "domainname",
 *     hostRecord: "@",
 *     type: "A",
 *     value: "192.168.99.99",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_alicloud as alicloud
 * # Create a new Domain record
 * record = alicloud.dns.Record("record",
 *     name="domainname",
 *     host_record="@",
 *     type="A",
 *     value="192.168.99.99")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AliCloud = Pulumi.AliCloud;
 * return await Deployment.RunAsync(() =>
 * {
 *     // Create a new Domain record
 *     var record = new AliCloud.Dns.Record("record", new()
 *     {
 *         Name = "domainname",
 *         HostRecord = "@",
 *         Type = "A",
 *         Value = "192.168.99.99",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-alicloud/sdk/v3/go/alicloud/dns"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		// Create a new Domain record
 * 		_, err := dns.NewRecord(ctx, "record", &dns.RecordArgs{
 * 			Name:       pulumi.String("domainname"),
 * 			HostRecord: pulumi.String("@"),
 * 			Type:       pulumi.String("A"),
 * 			Value:      pulumi.String("192.168.99.99"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.alicloud.dns.Record;
 * import com.pulumi.alicloud.dns.RecordArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         // Create a new Domain record
 *         var record = new Record("record", RecordArgs.builder()
 *             .name("domainname")
 *             .hostRecord("@")
 *             .type("A")
 *             .value("192.168.99.99")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   # Create a new Domain record
 *   record:
 *     type: alicloud:dns:Record
 *     properties:
 *       name: domainname
 *       hostRecord: '@'
 *       type: A
 *       value: 192.168.99.99
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * RDS record can be imported using the id, e.g.
 * ```sh
 * $ pulumi import alicloud:dns/record:Record example <id>
 * ```
 * @property hostRecord Host record for the domain record. This host_record can have at most 253 characters, and each part split with "." can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as "-",".","*","@",  and must not begin or end with "-".
 * @property name Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
 * @property priority The priority of domain record. Valid values are `[1-10]`. When the `type` is `MX`, this parameter is required.
 * @property routing The resolution line of domain record. Valid values are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/what-is-alibaba-cloud-dns) or using alicloud.dns.getResolutionLines in data source to get the value.
 * @property ttl The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
 * @property type The type of domain record. Valid values are `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
 * @property value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
 */
public data class RecordArgs(
    public val hostRecord: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val routing: Output<String>? = null,
    public val ttl: Output<Int>? = null,
    public val type: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.RecordArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.RecordArgs =
        com.pulumi.alicloud.dns.RecordArgs.builder()
            .hostRecord(hostRecord?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .routing(routing?.applyValue({ args0 -> args0 }))
            .ttl(ttl?.applyValue({ args0 -> args0 }))
            .type(type?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [RecordArgs].
 */
@PulumiTagMarker
public class RecordArgsBuilder internal constructor() {
    private var hostRecord: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var routing: Output<String>? = null

    private var ttl: Output<Int>? = null

    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Host record for the domain record. This host_record can have at most 253 characters, and each part split with "." can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as "-",".","*","@",  and must not begin or end with "-".
     */
    @JvmName("nepmrhcdplttbbho")
    public suspend fun hostRecord(`value`: Output<String>) {
        this.hostRecord = value
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("isqosgfebnxbxtba")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The priority of domain record. Valid values are `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    @JvmName("sgdpwkhkmtfndsdc")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The resolution line of domain record. Valid values are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/what-is-alibaba-cloud-dns) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    @JvmName("tvbigwmlplgxmvyg")
    public suspend fun routing(`value`: Output<String>) {
        this.routing = value
    }

    /**
     * @param value The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    @JvmName("xihinedoxhkgnkaw")
    public suspend fun ttl(`value`: Output<Int>) {
        this.ttl = value
    }

    /**
     * @param value The type of domain record. Valid values are `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    @JvmName("fkomneffdatwegpf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    @JvmName("hqpixhwdkogvmkin")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Host record for the domain record. This host_record can have at most 253 characters, and each part split with "." can have at most 63 characters, and must contain only alphanumeric characters or hyphens, such as "-",".","*","@",  and must not begin or end with "-".
     */
    @JvmName("jhlnwxmwbaacibxu")
    public suspend fun hostRecord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostRecord = mapped
    }

    /**
     * @param value Name of the domain. This name without suffix can have a string of 1 to 63 characters, must contain only alphanumeric characters or "-", and must not begin or end with "-", and "-" must not in the 3th and 4th character positions at the same time. Suffix `.sh` and `.tel` are not supported.
     */
    @JvmName("hbmcibheukmwrvry")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The priority of domain record. Valid values are `[1-10]`. When the `type` is `MX`, this parameter is required.
     */
    @JvmName("piurkgwerpaqyiag")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The resolution line of domain record. Valid values are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. When the `type` is `FORWORD_URL`, this parameter must be `default`. Default value is `default`. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/what-is-alibaba-cloud-dns) or using alicloud.dns.getResolutionLines in data source to get the value.
     */
    @JvmName("almylifpiniybjmh")
    public suspend fun routing(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routing = mapped
    }

    /**
     * @param value The effective time of domain record. Its scope depends on the edition of the cloud resolution. Free is `[600, 86400]`, Basic is `[120, 86400]`, Standard is `[60, 86400]`, Ultimate is `[10, 86400]`, Exclusive is `[1, 86400]`. Default value is `600`.
     */
    @JvmName("mgxsfeeadcfnsiel")
    public suspend fun ttl(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttl = mapped
    }

    /**
     * @param value The type of domain record. Valid values are `A`,`NS`,`MX`,`TXT`,`CNAME`,`SRV`,`AAAA`,`CAA`, `REDIRECT_URL` and `FORWORD_URL`.
     */
    @JvmName("hkbxboddvyehiyuf")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The value of domain record, When the `type` is `MX`,`NS`,`CNAME`,`SRV`, the server will treat the `value` as a fully qualified domain name, so it's no need to add a `.` at the end.
     */
    @JvmName("kgxybsgopigusgse")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): RecordArgs = RecordArgs(
        hostRecord = hostRecord,
        name = name,
        priority = priority,
        routing = routing,
        ttl = ttl,
        type = type,
        `value` = `value`,
    )
}
