@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.AccessStrategyDefaultAddrPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addrPoolId The ID of the address pool in the primary address pool group.
 * @property lbaWeight The weight of the address pool in the primary address pool group.
 */
public data class AccessStrategyDefaultAddrPoolArgs(
    public val addrPoolId: Output<String>,
    public val lbaWeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.AccessStrategyDefaultAddrPoolArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.AccessStrategyDefaultAddrPoolArgs =
        com.pulumi.alicloud.dns.inputs.AccessStrategyDefaultAddrPoolArgs.builder()
            .addrPoolId(addrPoolId.applyValue({ args0 -> args0 }))
            .lbaWeight(lbaWeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessStrategyDefaultAddrPoolArgs].
 */
@PulumiTagMarker
public class AccessStrategyDefaultAddrPoolArgsBuilder internal constructor() {
    private var addrPoolId: Output<String>? = null

    private var lbaWeight: Output<Int>? = null

    /**
     * @param value The ID of the address pool in the primary address pool group.
     */
    @JvmName("ioffcuoxgvduefut")
    public suspend fun addrPoolId(`value`: Output<String>) {
        this.addrPoolId = value
    }

    /**
     * @param value The weight of the address pool in the primary address pool group.
     */
    @JvmName("hnfkdwhykojrpnvt")
    public suspend fun lbaWeight(`value`: Output<Int>) {
        this.lbaWeight = value
    }

    /**
     * @param value The ID of the address pool in the primary address pool group.
     */
    @JvmName("dnoooswitgenvcjg")
    public suspend fun addrPoolId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.addrPoolId = mapped
    }

    /**
     * @param value The weight of the address pool in the primary address pool group.
     */
    @JvmName("rhaprejsstwdkcmy")
    public suspend fun lbaWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbaWeight = mapped
    }

    internal fun build(): AccessStrategyDefaultAddrPoolArgs = AccessStrategyDefaultAddrPoolArgs(
        addrPoolId = addrPoolId ?: throw PulumiNullFieldException("addrPoolId"),
        lbaWeight = lbaWeight,
    )
}
