@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.AccessStrategyFailoverAddrPoolArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property addrPoolId The ID of the address pool in the secondary address pool group.
 * @property lbaWeight The weight of the address pool in the secondary address pool group.
 */
public data class AccessStrategyFailoverAddrPoolArgs(
    public val addrPoolId: Output<String>? = null,
    public val lbaWeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.AccessStrategyFailoverAddrPoolArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.AccessStrategyFailoverAddrPoolArgs =
        com.pulumi.alicloud.dns.inputs.AccessStrategyFailoverAddrPoolArgs.builder()
            .addrPoolId(addrPoolId?.applyValue({ args0 -> args0 }))
            .lbaWeight(lbaWeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessStrategyFailoverAddrPoolArgs].
 */
@PulumiTagMarker
public class AccessStrategyFailoverAddrPoolArgsBuilder internal constructor() {
    private var addrPoolId: Output<String>? = null

    private var lbaWeight: Output<Int>? = null

    /**
     * @param value The ID of the address pool in the secondary address pool group.
     */
    @JvmName("efdnpchsklntmyko")
    public suspend fun addrPoolId(`value`: Output<String>) {
        this.addrPoolId = value
    }

    /**
     * @param value The weight of the address pool in the secondary address pool group.
     */
    @JvmName("feslcowswjkglouw")
    public suspend fun lbaWeight(`value`: Output<Int>) {
        this.lbaWeight = value
    }

    /**
     * @param value The ID of the address pool in the secondary address pool group.
     */
    @JvmName("jqrppjgpmephbarj")
    public suspend fun addrPoolId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.addrPoolId = mapped
    }

    /**
     * @param value The weight of the address pool in the secondary address pool group.
     */
    @JvmName("wokrkvsocutujhdt")
    public suspend fun lbaWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbaWeight = mapped
    }

    internal fun build(): AccessStrategyFailoverAddrPoolArgs = AccessStrategyFailoverAddrPoolArgs(
        addrPoolId = addrPoolId,
        lbaWeight = lbaWeight,
    )
}
