@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.AccessStrategyLineArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property lineCode The line code of the source region.
 */
public data class AccessStrategyLineArgs(
    public val lineCode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.AccessStrategyLineArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.AccessStrategyLineArgs =
        com.pulumi.alicloud.dns.inputs.AccessStrategyLineArgs.builder()
            .lineCode(lineCode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessStrategyLineArgs].
 */
@PulumiTagMarker
public class AccessStrategyLineArgsBuilder internal constructor() {
    private var lineCode: Output<String>? = null

    /**
     * @param value The line code of the source region.
     */
    @JvmName("dvcntmjecwwryiyw")
    public suspend fun lineCode(`value`: Output<String>) {
        this.lineCode = value
    }

    /**
     * @param value The line code of the source region.
     */
    @JvmName("bscbwrgquwbwtpmf")
    public suspend fun lineCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lineCode = mapped
    }

    internal fun build(): AccessStrategyLineArgs = AccessStrategyLineArgs(
        lineCode = lineCode,
    )
}
