@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property address The address that you want to add to the address pool.
 * @property attributeInfo The source region of the address. expressed as a JSON string. The structure is as follows:
 * * `LineCodes`: List of home lineCodes.
 * * `lineCodeRectifyType`: The rectification type of the line code. Default value: `AUTO`. Valid values: `NO_NEED`: no need for rectification. `RECTIFIED`: rectified. `AUTO`: automatic rectification.
 * @property lbaWeight The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
 * @property mode The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
 * @property remark The description of the address.
 */
public data class AddressPoolAddressArgs(
    public val address: Output<String>,
    public val attributeInfo: Output<String>,
    public val lbaWeight: Output<Int>? = null,
    public val mode: Output<String>,
    public val remark: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs =
        com.pulumi.alicloud.dns.inputs.AddressPoolAddressArgs.builder()
            .address(address.applyValue({ args0 -> args0 }))
            .attributeInfo(attributeInfo.applyValue({ args0 -> args0 }))
            .lbaWeight(lbaWeight?.applyValue({ args0 -> args0 }))
            .mode(mode.applyValue({ args0 -> args0 }))
            .remark(remark?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AddressPoolAddressArgs].
 */
@PulumiTagMarker
public class AddressPoolAddressArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var attributeInfo: Output<String>? = null

    private var lbaWeight: Output<Int>? = null

    private var mode: Output<String>? = null

    private var remark: Output<String>? = null

    /**
     * @param value The address that you want to add to the address pool.
     */
    @JvmName("cschqxjmevhigunn")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The source region of the address. expressed as a JSON string. The structure is as follows:
     * * `LineCodes`: List of home lineCodes.
     * * `lineCodeRectifyType`: The rectification type of the line code. Default value: `AUTO`. Valid values: `NO_NEED`: no need for rectification. `RECTIFIED`: rectified. `AUTO`: automatic rectification.
     */
    @JvmName("qysckmwywovkyboo")
    public suspend fun attributeInfo(`value`: Output<String>) {
        this.attributeInfo = value
    }

    /**
     * @param value The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
     */
    @JvmName("kggefxpqieklincl")
    public suspend fun lbaWeight(`value`: Output<Int>) {
        this.lbaWeight = value
    }

    /**
     * @param value The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
     */
    @JvmName("vhnienmkmjcxnpwk")
    public suspend fun mode(`value`: Output<String>) {
        this.mode = value
    }

    /**
     * @param value The description of the address.
     */
    @JvmName("cwpvkycoohbvmkim")
    public suspend fun remark(`value`: Output<String>) {
        this.remark = value
    }

    /**
     * @param value The address that you want to add to the address pool.
     */
    @JvmName("cfofpiryedeatnlk")
    public suspend fun address(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The source region of the address. expressed as a JSON string. The structure is as follows:
     * * `LineCodes`: List of home lineCodes.
     * * `lineCodeRectifyType`: The rectification type of the line code. Default value: `AUTO`. Valid values: `NO_NEED`: no need for rectification. `RECTIFIED`: rectified. `AUTO`: automatic rectification.
     */
    @JvmName("kctsjasddvfegnrm")
    public suspend fun attributeInfo(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeInfo = mapped
    }

    /**
     * @param value The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
     */
    @JvmName("cxrrnexlhqpyrudn")
    public suspend fun lbaWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lbaWeight = mapped
    }

    /**
     * @param value The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
     */
    @JvmName("dobncqxnjtjcdsye")
    public suspend fun mode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mode = mapped
    }

    /**
     * @param value The description of the address.
     */
    @JvmName("ywrwcyctorqopfum")
    public suspend fun remark(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.remark = mapped
    }

    internal fun build(): AddressPoolAddressArgs = AddressPoolAddressArgs(
        address = address ?: throw PulumiNullFieldException("address"),
        attributeInfo = attributeInfo ?: throw PulumiNullFieldException("attributeInfo"),
        lbaWeight = lbaWeight,
        mode = mode ?: throw PulumiNullFieldException("mode"),
        remark = remark,
    )
}
