@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property endIp The end IP address of the CIDR block.
 * @property startIp The start IP address of the CIDR block.
 */
public data class CustomLineIpSegmentListArgs(
    public val endIp: Output<String>,
    public val startIp: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs =
        com.pulumi.alicloud.dns.inputs.CustomLineIpSegmentListArgs.builder()
            .endIp(endIp.applyValue({ args0 -> args0 }))
            .startIp(startIp.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CustomLineIpSegmentListArgs].
 */
@PulumiTagMarker
public class CustomLineIpSegmentListArgsBuilder internal constructor() {
    private var endIp: Output<String>? = null

    private var startIp: Output<String>? = null

    /**
     * @param value The end IP address of the CIDR block.
     */
    @JvmName("kklfhxpygbqswwtn")
    public suspend fun endIp(`value`: Output<String>) {
        this.endIp = value
    }

    /**
     * @param value The start IP address of the CIDR block.
     */
    @JvmName("msjvapqadosyojfb")
    public suspend fun startIp(`value`: Output<String>) {
        this.startIp = value
    }

    /**
     * @param value The end IP address of the CIDR block.
     */
    @JvmName("eupmwftjllnfhpkc")
    public suspend fun endIp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.endIp = mapped
    }

    /**
     * @param value The start IP address of the CIDR block.
     */
    @JvmName("vpgbohaqbodfklxg")
    public suspend fun startIp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.startIp = mapped
    }

    internal fun build(): CustomLineIpSegmentListArgs = CustomLineIpSegmentListArgs(
        endIp = endIp ?: throw PulumiNullFieldException("endIp"),
        startIp = startIp ?: throw PulumiNullFieldException("startIp"),
    )
}
