@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetAccessStrategiesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessStrategies.
 * @property enableDetails Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Access Strategy IDs.
 * @property instanceId The Id of the associated instance.
 * @property lang The lang.
 * @property nameRegex A regex string to filter results by Access Strategy name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property strategyMode The type of the access policy. Valid values:
 * - `GEO`: based on geographic location.
 * - `LATENCY`: Based on delay.
 */
public data class GetAccessStrategiesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val instanceId: String,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val strategyMode: String,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetAccessStrategiesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetAccessStrategiesPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetAccessStrategiesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .strategyMode(strategyMode.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessStrategiesPlainArgs].
 */
@PulumiTagMarker
public class GetAccessStrategiesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var lang: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var strategyMode: String? = null

    /**
     * @param value Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("rjhjstjylslbeicr")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Access Strategy IDs.
     */
    @JvmName("cyndlssbxpfpnwpy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Access Strategy IDs.
     */
    @JvmName("akcxnmbqwsghmheu")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The Id of the associated instance.
     */
    @JvmName("dkgmhkklfnhymgru")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("gwtopfbamlmmgnsb")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value A regex string to filter results by Access Strategy name.
     */
    @JvmName("ktrwoojfmbpwonyf")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("brxlimvbrexrhmof")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The type of the access policy. Valid values:
     * - `GEO`: based on geographic location.
     * - `LATENCY`: Based on delay.
     */
    @JvmName("pjhiejkcmaqirnyv")
    public suspend fun strategyMode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.strategyMode = mapped
    }

    internal fun build(): GetAccessStrategiesPlainArgs = GetAccessStrategiesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        lang = lang,
        nameRegex = nameRegex,
        outputFile = outputFile,
        strategyMode = strategyMode ?: throw PulumiNullFieldException("strategyMode"),
    )
}
