@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetAlidnsDomainsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlidnsDomains.
 * @property aliDomain Specifies whether the domain is from Alibaba Cloud or not.
 * @property domainNameRegex A regex string to filter results by the domain name.
 * @property enableDetails
 * @property groupId Domain group ID, if not filled, the default is all groups.
 * @property groupNameRegex A regex string to filter results by the group name.
 * @property ids A list of domain IDs.
 * @property instanceId Cloud analysis product ID.
 * @property keyWord The keywords are searched according to the `%KeyWord%` mode, which is not case sensitive.
 * @property lang User language.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property resourceGroupId The Id of resource group which the dns belongs.
 * @property searchMode Search mode, `LIKE` fuzzy search, `EXACT` exact search.
 * @property starmark Whether to query the domain name star.
 * @property tags A mapping of tags to assign to the resource.
 * @property versionCode Cloud analysis version code.
 */
public data class GetAlidnsDomainsPlainArgs(
    public val aliDomain: Boolean? = null,
    public val domainNameRegex: String? = null,
    public val enableDetails: Boolean? = null,
    public val groupId: String? = null,
    public val groupNameRegex: String? = null,
    public val ids: List<String>? = null,
    public val instanceId: String? = null,
    public val keyWord: String? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val searchMode: String? = null,
    public val starmark: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val versionCode: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetAlidnsDomainsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetAlidnsDomainsPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetAlidnsDomainsPlainArgs.builder()
            .aliDomain(aliDomain?.let({ args0 -> args0 }))
            .domainNameRegex(domainNameRegex?.let({ args0 -> args0 }))
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .groupNameRegex(groupNameRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .instanceId(instanceId?.let({ args0 -> args0 }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 }))
            .searchMode(searchMode?.let({ args0 -> args0 }))
            .starmark(starmark?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .versionCode(versionCode?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlidnsDomainsPlainArgs].
 */
@PulumiTagMarker
public class GetAlidnsDomainsPlainArgsBuilder internal constructor() {
    private var aliDomain: Boolean? = null

    private var domainNameRegex: String? = null

    private var enableDetails: Boolean? = null

    private var groupId: String? = null

    private var groupNameRegex: String? = null

    private var ids: List<String>? = null

    private var instanceId: String? = null

    private var keyWord: String? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var resourceGroupId: String? = null

    private var searchMode: String? = null

    private var starmark: Boolean? = null

    private var tags: Map<String, String>? = null

    private var versionCode: String? = null

    /**
     * @param value Specifies whether the domain is from Alibaba Cloud or not.
     */
    @JvmName("rwjcrtkbgwbosjsj")
    public suspend fun aliDomain(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.aliDomain = mapped
    }

    /**
     * @param value A regex string to filter results by the domain name.
     */
    @JvmName("hasvonijxpjkgscr")
    public suspend fun domainNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainNameRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("cjixqtbjvcdufolj")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value Domain group ID, if not filled, the default is all groups.
     */
    @JvmName("iibwoigmqlobrtcv")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value A regex string to filter results by the group name.
     */
    @JvmName("fwhrgbmjwkvmikrx")
    public suspend fun groupNameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupNameRegex = mapped
    }

    /**
     * @param value A list of domain IDs.
     */
    @JvmName("cnqlieddgphnjnbx")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of domain IDs.
     */
    @JvmName("twoxslxfiwcabkdb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Cloud analysis product ID.
     */
    @JvmName("ulclitqsfhdrepio")
    public suspend fun instanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.instanceId = mapped
    }

    /**
     * @param value The keywords are searched according to the `%KeyWord%` mode, which is not case sensitive.
     */
    @JvmName("touqcplbersdttaf")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("srpinuvjiiqxpgmu")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xmupputkqiwtgbwb")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The Id of resource group which the dns belongs.
     */
    @JvmName("cdbsonxwtlvqfbcc")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    /**
     * @param value Search mode, `LIKE` fuzzy search, `EXACT` exact search.
     */
    @JvmName("kkpdjuvjmpyyehdj")
    public suspend fun searchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchMode = mapped
    }

    /**
     * @param value Whether to query the domain name star.
     */
    @JvmName("jrqepfrbjgkfaogt")
    public suspend fun starmark(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.starmark = mapped
    }

    /**
     * @param value A mapping of tags to assign to the resource.
     */
    @JvmName("bbmplfihcshkgryc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A mapping of tags to assign to the resource.
     */
    @JvmName("gffevdiikgyrrreq")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Cloud analysis version code.
     */
    @JvmName("kttlkholsdfmdhtb")
    public suspend fun versionCode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.versionCode = mapped
    }

    internal fun build(): GetAlidnsDomainsPlainArgs = GetAlidnsDomainsPlainArgs(
        aliDomain = aliDomain,
        domainNameRegex = domainNameRegex,
        enableDetails = enableDetails,
        groupId = groupId,
        groupNameRegex = groupNameRegex,
        ids = ids,
        instanceId = instanceId,
        keyWord = keyWord,
        lang = lang,
        outputFile = outputFile,
        resourceGroupId = resourceGroupId,
        searchMode = searchMode,
        starmark = starmark,
        tags = tags,
        versionCode = versionCode,
    )
}
