@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetAlidnsRecordsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlidnsRecords.
 * @property direction Sorting direction. Valid values: `DESC`,`ASC`. Default to `AESC`.
 * @property domainName The domain name associated to the records.
 * @property groupId Domain name group ID.
 * @property ids A list of record IDs.
 * @property keyWord Keywords.
 * @property lang User language.
 * @property line ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
 * @property orderBy Sort by. Sort from newest to oldest according to the time added by resolution.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property rrKeyWord The keywords recorded by the host are searched according to the `%RRKeyWord%` mode, and are not case sensitive.
 * @property rrRegex Host record regex.
 * @property searchMode Search mode, Valid values: `LIKE`, `EXACT`, `ADVANCED`, `LIKE` (fuzzy), `EXACT` (accurate) search supports KeyWord field, `ADVANCED` (advanced) mode supports other fields.
 * @property status Record status. Valid values: `ENABLE` and `DISABLE`.
 * @property type Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
 * @property typeKeyWord Analyze type keywords, search by full match, not case sensitive.
 * @property valueKeyWord The keywords of the recorded value are searched according to the `%ValueKeyWord%` mode, and are not case sensitive.
 * @property valueRegex Host record value regex.
 */
public data class GetAlidnsRecordsPlainArgs(
    public val direction: String? = null,
    public val domainName: String,
    public val groupId: Int? = null,
    public val ids: List<String>? = null,
    public val keyWord: String? = null,
    public val lang: String? = null,
    public val line: String? = null,
    public val orderBy: String? = null,
    public val outputFile: String? = null,
    public val rrKeyWord: String? = null,
    public val rrRegex: String? = null,
    public val searchMode: String? = null,
    public val status: String? = null,
    public val type: String? = null,
    public val typeKeyWord: String? = null,
    public val valueKeyWord: String? = null,
    public val valueRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetAlidnsRecordsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetAlidnsRecordsPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetAlidnsRecordsPlainArgs.builder()
            .direction(direction?.let({ args0 -> args0 }))
            .domainName(domainName.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyWord(keyWord?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .line(line?.let({ args0 -> args0 }))
            .orderBy(orderBy?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .rrKeyWord(rrKeyWord?.let({ args0 -> args0 }))
            .rrRegex(rrRegex?.let({ args0 -> args0 }))
            .searchMode(searchMode?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .typeKeyWord(typeKeyWord?.let({ args0 -> args0 }))
            .valueKeyWord(valueKeyWord?.let({ args0 -> args0 }))
            .valueRegex(valueRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlidnsRecordsPlainArgs].
 */
@PulumiTagMarker
public class GetAlidnsRecordsPlainArgsBuilder internal constructor() {
    private var direction: String? = null

    private var domainName: String? = null

    private var groupId: Int? = null

    private var ids: List<String>? = null

    private var keyWord: String? = null

    private var lang: String? = null

    private var line: String? = null

    private var orderBy: String? = null

    private var outputFile: String? = null

    private var rrKeyWord: String? = null

    private var rrRegex: String? = null

    private var searchMode: String? = null

    private var status: String? = null

    private var type: String? = null

    private var typeKeyWord: String? = null

    private var valueKeyWord: String? = null

    private var valueRegex: String? = null

    /**
     * @param value Sorting direction. Valid values: `DESC`,`ASC`. Default to `AESC`.
     */
    @JvmName("wclbbivddthrsxvn")
    public suspend fun direction(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.direction = mapped
    }

    /**
     * @param value The domain name associated to the records.
     */
    @JvmName("vpcqqemipgibivqj")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Domain name group ID.
     */
    @JvmName("baxwogvhalqaewem")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value A list of record IDs.
     */
    @JvmName("ssjvatammooaavdd")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of record IDs.
     */
    @JvmName("iismasnayasssjxg")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Keywords.
     */
    @JvmName("ilnoxkqgtowloxft")
    public suspend fun keyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyWord = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("udsspfpmaqdjbmfq")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
     */
    @JvmName("onahtnhisjmdfcwh")
    public suspend fun line(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.line = mapped
    }

    /**
     * @param value Sort by. Sort from newest to oldest according to the time added by resolution.
     */
    @JvmName("kvrudgapwvjkuifs")
    public suspend fun orderBy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.orderBy = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ifnksjnifarhombf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The keywords recorded by the host are searched according to the `%RRKeyWord%` mode, and are not case sensitive.
     */
    @JvmName("xoukmfrymctavlwi")
    public suspend fun rrKeyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rrKeyWord = mapped
    }

    /**
     * @param value Host record regex.
     */
    @JvmName("hwpfmggveghhqlxp")
    public suspend fun rrRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.rrRegex = mapped
    }

    /**
     * @param value Search mode, Valid values: `LIKE`, `EXACT`, `ADVANCED`, `LIKE` (fuzzy), `EXACT` (accurate) search supports KeyWord field, `ADVANCED` (advanced) mode supports other fields.
     */
    @JvmName("hpmglxpdxxxocycc")
    public suspend fun searchMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.searchMode = mapped
    }

    /**
     * @param value Record status. Valid values: `ENABLE` and `DISABLE`.
     */
    @JvmName("klmckbybjrmwjjpg")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
     */
    @JvmName("lnfbnrjhkrnlqfmk")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Analyze type keywords, search by full match, not case sensitive.
     */
    @JvmName("hbbwmgveyvcwsaug")
    public suspend fun typeKeyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.typeKeyWord = mapped
    }

    /**
     * @param value The keywords of the recorded value are searched according to the `%ValueKeyWord%` mode, and are not case sensitive.
     */
    @JvmName("wjdxlrrlpvjegwfr")
    public suspend fun valueKeyWord(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.valueKeyWord = mapped
    }

    /**
     * @param value Host record value regex.
     */
    @JvmName("bgboywbatqwlqtpb")
    public suspend fun valueRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.valueRegex = mapped
    }

    internal fun build(): GetAlidnsRecordsPlainArgs = GetAlidnsRecordsPlainArgs(
        direction = direction,
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        groupId = groupId,
        ids = ids,
        keyWord = keyWord,
        lang = lang,
        line = line,
        orderBy = orderBy,
        outputFile = outputFile,
        rrKeyWord = rrKeyWord,
        rrRegex = rrRegex,
        searchMode = searchMode,
        status = status,
        type = type,
        typeKeyWord = typeKeyWord,
        valueKeyWord = valueKeyWord,
        valueRegex = valueRegex,
    )
}
