@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetDomainRecordsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomainRecords.
 * @property domainName
 * @property hostRecordRegex
 * @property ids
 * @property isLocked
 * @property line
 * @property outputFile
 * @property status
 * @property type
 * @property valueRegex
 */
public data class GetDomainRecordsPlainArgs(
    public val domainName: String,
    public val hostRecordRegex: String? = null,
    public val ids: List<String>? = null,
    public val isLocked: Boolean? = null,
    public val line: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val type: String? = null,
    public val valueRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetDomainRecordsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetDomainRecordsPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetDomainRecordsPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .hostRecordRegex(hostRecordRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isLocked(isLocked?.let({ args0 -> args0 }))
            .line(line?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .valueRegex(valueRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainRecordsPlainArgs].
 */
@PulumiTagMarker
public class GetDomainRecordsPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var hostRecordRegex: String? = null

    private var ids: List<String>? = null

    private var isLocked: Boolean? = null

    private var line: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var type: String? = null

    private var valueRegex: String? = null

    /**
     * @param value
     */
    @JvmName("ocyfnixhkboyrrfj")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value
     */
    @JvmName("ckpksudjascfefyf")
    public suspend fun hostRecordRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostRecordRegex = mapped
    }

    /**
     * @param value
     */
    @JvmName("nnmgrmwbdvigafnm")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values
     */
    @JvmName("onhgckmfcylfybxx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("plheirtotkinpolf")
    public suspend fun isLocked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isLocked = mapped
    }

    /**
     * @param value
     */
    @JvmName("ygrrtgpyqcwlpote")
    public suspend fun line(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.line = mapped
    }

    /**
     * @param value
     */
    @JvmName("qikiuvcecomixgmj")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("jugnloiossgwminv")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value
     */
    @JvmName("hdgjvmfjoqtpxgwd")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value
     */
    @JvmName("hwcbcqdvbyiytlus")
    public suspend fun valueRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.valueRegex = mapped
    }

    internal fun build(): GetDomainRecordsPlainArgs = GetDomainRecordsPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        hostRecordRegex = hostRecordRegex,
        ids = ids,
        isLocked = isLocked,
        line = line,
        outputFile = outputFile,
        status = status,
        type = type,
        valueRegex = valueRegex,
    )
}
