@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetDomainTxtGuidPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDomainTxtGuid.
 * @property domainName Verified domain name.
 * @property lang User language.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property type Txt verification function. Value:`ADD_SUB_DOMAIN`, `RETRIEVAL`.
 */
public data class GetDomainTxtGuidPlainArgs(
    public val domainName: String,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val type: String,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetDomainTxtGuidPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetDomainTxtGuidPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetDomainTxtGuidPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .type(type.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDomainTxtGuidPlainArgs].
 */
@PulumiTagMarker
public class GetDomainTxtGuidPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var type: String? = null

    /**
     * @param value Verified domain name.
     */
    @JvmName("kpvcqaxoupucuwxw")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value User language.
     */
    @JvmName("gnrraqhdbrnnmdyj")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hqsawelndwywylrg")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Txt verification function. Value:`ADD_SUB_DOMAIN`, `RETRIEVAL`.
     */
    @JvmName("nfseeurptxvpmhug")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetDomainTxtGuidPlainArgs = GetDomainTxtGuidPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        lang = lang,
        outputFile = outputFile,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
