@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetGtmInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGtmInstances.
 * @property ids A list of Gtm Instance IDs.
 * @property lang The lang.
 * @property resourceGroupId The ID of the resource group.
 */
public data class GetGtmInstancesPlainArgs(
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val resourceGroupId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetGtmInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetGtmInstancesPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetGtmInstancesPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .resourceGroupId(resourceGroupId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGtmInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetGtmInstancesPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var lang: String? = null

    private var resourceGroupId: String? = null

    /**
     * @param value A list of Gtm Instance IDs.
     */
    @JvmName("pilragsdcttubtxy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Gtm Instance IDs.
     */
    @JvmName("gfufinpxyyvblitj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The lang.
     */
    @JvmName("anywmdnbfylvlkbx")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value The ID of the resource group.
     */
    @JvmName("vqlovdjiqaitwlrb")
    public suspend fun resourceGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.resourceGroupId = mapped
    }

    internal fun build(): GetGtmInstancesPlainArgs = GetGtmInstancesPlainArgs(
        ids = ids,
        lang = lang,
        resourceGroupId = resourceGroupId,
    )
}
