@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getInstances.
 * @property domainType
 * @property ids A list of instance IDs.
 * @property lang
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property userClientIp
 */
public data class GetInstancesPlainArgs(
    public val domainType: String? = null,
    public val ids: List<String>? = null,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val userClientIp: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetInstancesPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetInstancesPlainArgs.builder()
            .domainType(domainType?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lang(lang?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .userClientIp(userClientIp?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetInstancesPlainArgsBuilder internal constructor() {
    private var domainType: String? = null

    private var ids: List<String>? = null

    private var lang: String? = null

    private var outputFile: String? = null

    private var userClientIp: String? = null

    /**
     * @param value
     */
    @JvmName("sakanjngupyhhjub")
    public suspend fun domainType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainType = mapped
    }

    /**
     * @param value A list of instance IDs.
     */
    @JvmName("wtcoehwbvyrdixwg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of instance IDs.
     */
    @JvmName("gfmxvubrtidoowqr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("pqbkyhgddxithlvy")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("wqmklprphdgcwgpa")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("dqbbtomdgyfnjcbu")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userClientIp = mapped
    }

    internal fun build(): GetInstancesPlainArgs = GetInstancesPlainArgs(
        domainType = domainType,
        ids = ids,
        lang = lang,
        outputFile = outputFile,
        userClientIp = userClientIp,
    )
}
