@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetRecordsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getRecords.
 * @property domainName The domain name associated to the records.
 * @property hostRecordRegex Host record regex.
 * @property ids A list of record IDs.
 * @property isLocked Whether the record is locked or not.
 * @property line ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status Record status. Valid items are `ENABLE` and `DISABLE`.
 * @property type Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
 * @property valueRegex Host record value regex.
 */
public data class GetRecordsPlainArgs(
    public val domainName: String,
    public val hostRecordRegex: String? = null,
    public val ids: List<String>? = null,
    public val isLocked: Boolean? = null,
    public val line: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val type: String? = null,
    public val valueRegex: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetRecordsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetRecordsPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetRecordsPlainArgs.builder()
            .domainName(domainName.let({ args0 -> args0 }))
            .hostRecordRegex(hostRecordRegex?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .isLocked(isLocked?.let({ args0 -> args0 }))
            .line(line?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 }))
            .valueRegex(valueRegex?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRecordsPlainArgs].
 */
@PulumiTagMarker
public class GetRecordsPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var hostRecordRegex: String? = null

    private var ids: List<String>? = null

    private var isLocked: Boolean? = null

    private var line: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var type: String? = null

    private var valueRegex: String? = null

    /**
     * @param value The domain name associated to the records.
     */
    @JvmName("iamodvkykpijqlsr")
    public suspend fun domainName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value Host record regex.
     */
    @JvmName("rnpedshxhsnafpma")
    public suspend fun hostRecordRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.hostRecordRegex = mapped
    }

    /**
     * @param value A list of record IDs.
     */
    @JvmName("cyhyvncuwwasupwg")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of record IDs.
     */
    @JvmName("ijejdwwofolkytnc")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value Whether the record is locked or not.
     */
    @JvmName("lmsjdhieqlkxqjnq")
    public suspend fun isLocked(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.isLocked = mapped
    }

    /**
     * @param value ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
     */
    @JvmName("ivaabvqdmslsxnrx")
    public suspend fun line(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.line = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("yqdfmmxrhfgoyyqh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Record status. Valid items are `ENABLE` and `DISABLE`.
     */
    @JvmName("qcwfscatwfrklrku")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
     */
    @JvmName("qomwauhuojchdtgn")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    /**
     * @param value Host record value regex.
     */
    @JvmName("absdsgrtwoyinjce")
    public suspend fun valueRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.valueRegex = mapped
    }

    internal fun build(): GetRecordsPlainArgs = GetRecordsPlainArgs(
        domainName = domainName ?: throw PulumiNullFieldException("domainName"),
        hostRecordRegex = hostRecordRegex,
        ids = ids,
        isLocked = isLocked,
        line = line,
        outputFile = outputFile,
        status = status,
        type = type,
        valueRegex = valueRegex,
    )
}
