@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GetResolutionLinesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getResolutionLines.
 * @property domainName Domain Name.
 * @property lang language.
 * @property lineCodes A list of lines codes.
 * @property lineDisplayNames A list of line display names.
 * @property lineNames
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property userClientIp The ip of user client.
 */
public data class GetResolutionLinesPlainArgs(
    public val domainName: String? = null,
    public val lang: String? = null,
    public val lineCodes: List<String>? = null,
    public val lineDisplayNames: List<String>? = null,
    public val lineNames: List<String>? = null,
    public val outputFile: String? = null,
    public val userClientIp: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GetResolutionLinesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GetResolutionLinesPlainArgs =
        com.pulumi.alicloud.dns.inputs.GetResolutionLinesPlainArgs.builder()
            .domainName(domainName?.let({ args0 -> args0 }))
            .lang(lang?.let({ args0 -> args0 }))
            .lineCodes(lineCodes?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lineDisplayNames(lineDisplayNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .lineNames(lineNames?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .userClientIp(userClientIp?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetResolutionLinesPlainArgs].
 */
@PulumiTagMarker
public class GetResolutionLinesPlainArgsBuilder internal constructor() {
    private var domainName: String? = null

    private var lang: String? = null

    private var lineCodes: List<String>? = null

    private var lineDisplayNames: List<String>? = null

    private var lineNames: List<String>? = null

    private var outputFile: String? = null

    private var userClientIp: String? = null

    /**
     * @param value Domain Name.
     */
    @JvmName("gpntlhpaudgualam")
    public suspend fun domainName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.domainName = mapped
    }

    /**
     * @param value language.
     */
    @JvmName("xisglfpyxifeevev")
    public suspend fun lang(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lang = mapped
    }

    /**
     * @param value A list of lines codes.
     */
    @JvmName("idwepajfhnswvlmi")
    public suspend fun lineCodes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lineCodes = mapped
    }

    /**
     * @param values A list of lines codes.
     */
    @JvmName("bnxkndjqvddpxiny")
    public suspend fun lineCodes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lineCodes = mapped
    }

    /**
     * @param value A list of line display names.
     */
    @JvmName("oargmtndeptubkoo")
    public suspend fun lineDisplayNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lineDisplayNames = mapped
    }

    /**
     * @param values A list of line display names.
     */
    @JvmName("ibeukhmpkguugtiq")
    public suspend fun lineDisplayNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lineDisplayNames = mapped
    }

    /**
     * @param value
     */
    @JvmName("nfaxqsoqydpstusg")
    public suspend fun lineNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.lineNames = mapped
    }

    /**
     * @param values
     */
    @JvmName("lcoxgopqiqydkafb")
    public suspend fun lineNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.lineNames = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("bbjgcujhnfdismlo")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ip of user client.
     */
    @JvmName("beeadkrnuvisrgvb")
    public suspend fun userClientIp(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.userClientIp = mapped
    }

    internal fun build(): GetResolutionLinesPlainArgs = GetResolutionLinesPlainArgs(
        domainName = domainName,
        lang = lang,
        lineCodes = lineCodes,
        lineDisplayNames = lineDisplayNames,
        lineNames = lineNames,
        outputFile = outputFile,
        userClientIp = userClientIp,
    )
}
