@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dingtalkNotice Whether to configure DingTalk notifications. Valid values: `true`, `false`.
 * @property emailNotice Whether to configure mail notification. Valid values: `true`, `false`.
 * @property noticeType The Alarm Event Type.
 * - `ADDR_ALERT`: Address not available.
 * - `ADDR_RESUME`: Address Recovery available.
 * - `ADDR_POOL_GROUP_UNAVAILABLE`: Address pool collection not available.
 * - `ADDR_POOL_GROUP_AVAILABLE`: Address pool collection recovery available.
 * - `ACCESS_STRATEGY_POOL_GROUP_SWITCH`: Primary/standby address pool switch.
 * - `MONITOR_NODE_IP_CHANGE`: Monitoring node IP address changes.
 * @property smsNotice Whether to configure SMS notification. Valid values: `true`, `false`.
 */
public data class GtmInstanceAlertConfigArgs(
    public val dingtalkNotice: Output<Boolean>? = null,
    public val emailNotice: Output<Boolean>? = null,
    public val noticeType: Output<String>? = null,
    public val smsNotice: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs =
        com.pulumi.alicloud.dns.inputs.GtmInstanceAlertConfigArgs.builder()
            .dingtalkNotice(dingtalkNotice?.applyValue({ args0 -> args0 }))
            .emailNotice(emailNotice?.applyValue({ args0 -> args0 }))
            .noticeType(noticeType?.applyValue({ args0 -> args0 }))
            .smsNotice(smsNotice?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GtmInstanceAlertConfigArgs].
 */
@PulumiTagMarker
public class GtmInstanceAlertConfigArgsBuilder internal constructor() {
    private var dingtalkNotice: Output<Boolean>? = null

    private var emailNotice: Output<Boolean>? = null

    private var noticeType: Output<String>? = null

    private var smsNotice: Output<Boolean>? = null

    /**
     * @param value Whether to configure DingTalk notifications. Valid values: `true`, `false`.
     */
    @JvmName("dsordkossecxskkw")
    public suspend fun dingtalkNotice(`value`: Output<Boolean>) {
        this.dingtalkNotice = value
    }

    /**
     * @param value Whether to configure mail notification. Valid values: `true`, `false`.
     */
    @JvmName("cflsxsqgqmkehada")
    public suspend fun emailNotice(`value`: Output<Boolean>) {
        this.emailNotice = value
    }

    /**
     * @param value The Alarm Event Type.
     * - `ADDR_ALERT`: Address not available.
     * - `ADDR_RESUME`: Address Recovery available.
     * - `ADDR_POOL_GROUP_UNAVAILABLE`: Address pool collection not available.
     * - `ADDR_POOL_GROUP_AVAILABLE`: Address pool collection recovery available.
     * - `ACCESS_STRATEGY_POOL_GROUP_SWITCH`: Primary/standby address pool switch.
     * - `MONITOR_NODE_IP_CHANGE`: Monitoring node IP address changes.
     */
    @JvmName("vaykmmgnakpqbdnq")
    public suspend fun noticeType(`value`: Output<String>) {
        this.noticeType = value
    }

    /**
     * @param value Whether to configure SMS notification. Valid values: `true`, `false`.
     */
    @JvmName("ryglqlsytdlvmhjt")
    public suspend fun smsNotice(`value`: Output<Boolean>) {
        this.smsNotice = value
    }

    /**
     * @param value Whether to configure DingTalk notifications. Valid values: `true`, `false`.
     */
    @JvmName("txrqwitfdgjtdxfu")
    public suspend fun dingtalkNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dingtalkNotice = mapped
    }

    /**
     * @param value Whether to configure mail notification. Valid values: `true`, `false`.
     */
    @JvmName("ahbkrqsnorjqjclc")
    public suspend fun emailNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailNotice = mapped
    }

    /**
     * @param value The Alarm Event Type.
     * - `ADDR_ALERT`: Address not available.
     * - `ADDR_RESUME`: Address Recovery available.
     * - `ADDR_POOL_GROUP_UNAVAILABLE`: Address pool collection not available.
     * - `ADDR_POOL_GROUP_AVAILABLE`: Address pool collection recovery available.
     * - `ACCESS_STRATEGY_POOL_GROUP_SWITCH`: Primary/standby address pool switch.
     * - `MONITOR_NODE_IP_CHANGE`: Monitoring node IP address changes.
     */
    @JvmName("ttxyjmfsgxjyjgtp")
    public suspend fun noticeType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.noticeType = mapped
    }

    /**
     * @param value Whether to configure SMS notification. Valid values: `true`, `false`.
     */
    @JvmName("jwjlxyxjfecxxdvo")
    public suspend fun smsNotice(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smsNotice = mapped
    }

    internal fun build(): GtmInstanceAlertConfigArgs = GtmInstanceAlertConfigArgs(
        dingtalkNotice = dingtalkNotice,
        emailNotice = emailNotice,
        noticeType = noticeType,
        smsNotice = smsNotice,
    )
}
