@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.inputs

import com.pulumi.alicloud.dns.inputs.MonitorConfigIspCityNodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cityCode The code of the city node to monitor.
 * @property ispCode The code of the Internet provider service (ISP) node to monitor.
 */
public data class MonitorConfigIspCityNodeArgs(
    public val cityCode: Output<String>,
    public val ispCode: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.dns.inputs.MonitorConfigIspCityNodeArgs> {
    override fun toJava(): com.pulumi.alicloud.dns.inputs.MonitorConfigIspCityNodeArgs =
        com.pulumi.alicloud.dns.inputs.MonitorConfigIspCityNodeArgs.builder()
            .cityCode(cityCode.applyValue({ args0 -> args0 }))
            .ispCode(ispCode.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorConfigIspCityNodeArgs].
 */
@PulumiTagMarker
public class MonitorConfigIspCityNodeArgsBuilder internal constructor() {
    private var cityCode: Output<String>? = null

    private var ispCode: Output<String>? = null

    /**
     * @param value The code of the city node to monitor.
     */
    @JvmName("udcynmywmnkrqwcy")
    public suspend fun cityCode(`value`: Output<String>) {
        this.cityCode = value
    }

    /**
     * @param value The code of the Internet provider service (ISP) node to monitor.
     */
    @JvmName("jgurvncgjmyetfjh")
    public suspend fun ispCode(`value`: Output<String>) {
        this.ispCode = value
    }

    /**
     * @param value The code of the city node to monitor.
     */
    @JvmName("uqkihbuedjwpiwla")
    public suspend fun cityCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cityCode = mapped
    }

    /**
     * @param value The code of the Internet provider service (ISP) node to monitor.
     */
    @JvmName("xxpyqaifqokgcfnw")
    public suspend fun ispCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ispCode = mapped
    }

    internal fun build(): MonitorConfigIspCityNodeArgs = MonitorConfigIspCityNodeArgs(
        cityCode = cityCode ?: throw PulumiNullFieldException("cityCode"),
        ispCode = ispCode ?: throw PulumiNullFieldException("ispCode"),
    )
}
