@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addrPoolId The ID of the address pool in the primary address pool group.
 * @property lbaWeight The weight of the address pool in the primary address pool group.
 */
public data class AccessStrategyDefaultAddrPool(
    public val addrPoolId: String,
    public val lbaWeight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.AccessStrategyDefaultAddrPool): AccessStrategyDefaultAddrPool = AccessStrategyDefaultAddrPool(
            addrPoolId = javaType.addrPoolId(),
            lbaWeight = javaType.lbaWeight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
