@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addrPoolId The ID of the address pool in the secondary address pool group.
 * @property lbaWeight The weight of the address pool in the secondary address pool group.
 */
public data class AccessStrategyFailoverAddrPool(
    public val addrPoolId: String? = null,
    public val lbaWeight: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.AccessStrategyFailoverAddrPool): AccessStrategyFailoverAddrPool = AccessStrategyFailoverAddrPool(
            addrPoolId = javaType.addrPoolId().map({ args0 -> args0 }).orElse(null),
            lbaWeight = javaType.lbaWeight().map({ args0 -> args0 }).orElse(null),
        )
    }
}
