@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The address that you want to add to the address pool.
 * @property attributeInfo The source region of the address. expressed as a JSON string. The structure is as follows:
 * * `LineCodes`: List of home lineCodes.
 * * `lineCodeRectifyType`: The rectification type of the line code. Default value: `AUTO`. Valid values: `NO_NEED`: no need for rectification. `RECTIFIED`: rectified. `AUTO`: automatic rectification.
 * @property lbaWeight The weight of the address. **NOTE:** The attribute is valid when the attribute `lba_strategy` is `RATIO`.
 * @property mode The type of the address. Valid values:`SMART`, `ONLINE` and `OFFLINE`.
 * @property remark The description of the address.
 */
public data class AddressPoolAddress(
    public val address: String,
    public val attributeInfo: String,
    public val lbaWeight: Int? = null,
    public val mode: String,
    public val remark: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.AddressPoolAddress): AddressPoolAddress = AddressPoolAddress(
            address = javaType.address(),
            attributeInfo = javaType.attributeInfo(),
            lbaWeight = javaType.lbaWeight().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode(),
            remark = javaType.remark().map({ args0 -> args0 }).orElse(null),
        )
    }
}
