@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessStrategies.
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instanceId
 * @property lang
 * @property nameRegex
 * @property names
 * @property outputFile
 * @property strategies
 * @property strategyMode
 */
public data class GetAccessStrategiesResult(
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String,
    public val lang: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val strategies: List<GetAccessStrategiesStrategy>,
    public val strategyMode: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAccessStrategiesResult): GetAccessStrategiesResult = GetAccessStrategiesResult(
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            strategies = javaType.strategies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesStrategy.Companion.toKotlin(args0)
                })
            }),
            strategyMode = javaType.strategyMode(),
        )
    }
}
