@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accessMode The primary/secondary switchover policy for address pool groups.
 * @property accessStrategyId The first ID of the resource.
 * @property createTime The time when the access policy was created.
 * @property createTimestamp The timestamp that indicates when the access policy was created.
 * @property defaultAddrPoolType The type of the primary address pool.
 * @property defaultAddrPools The address pools in the primary address pool group.
 * @property defaultAvailableAddrNum The number of addresses currently available in the primary address pool.
 * @property defaultLatencyOptimization Indicates whether scheduling optimization for latency resolution was enabled for the primary address pool group.
 * @property defaultLbaStrategy The load balancing policy of the primary address pool group.
 * @property defaultMaxReturnAddrNum The maximum number of addresses returned by the primary address pool set.
 * @property defaultMinAvailableAddrNum The minimum number of available addresses for the primary address pool set.
 * @property effectiveAddrPoolGroupType The type of the active address pool group.
 * @property failoverAddrPoolType The type of the secondary address pool.
 * @property failoverAddrPools The address pools in the secondary address pool group.
 * @property failoverAvailableAddrNum The number of available addresses in the standby address pool.
 * @property failoverLatencyOptimization Indicates whether scheduling optimization for latency resolution was enabled for the secondary address pool group.
 * @property failoverLbaStrategy The load balancing policy of the secondary address pool group.
 * @property failoverMaxReturnAddrNum The maximum number of returned addresses in the standby address pool.
 * @property failoverMinAvailableAddrNum The minimum number of available addresses in the standby address pool.
 * @property id The ID of the Access Strategy.
 * @property instanceId The Id of the associated instance.
 * @property lines List of source regions.
 * @property strategyMode The type of the access policy.
 * @property strategyName The name of the access policy.
 */
public data class GetAccessStrategiesStrategy(
    public val accessMode: String,
    public val accessStrategyId: String,
    public val createTime: String,
    public val createTimestamp: String,
    public val defaultAddrPoolType: String,
    public val defaultAddrPools: List<GetAccessStrategiesStrategyDefaultAddrPool>,
    public val defaultAvailableAddrNum: Int,
    public val defaultLatencyOptimization: String,
    public val defaultLbaStrategy: String,
    public val defaultMaxReturnAddrNum: Int,
    public val defaultMinAvailableAddrNum: Int,
    public val effectiveAddrPoolGroupType: String,
    public val failoverAddrPoolType: String,
    public val failoverAddrPools: List<GetAccessStrategiesStrategyFailoverAddrPool>,
    public val failoverAvailableAddrNum: Int,
    public val failoverLatencyOptimization: String,
    public val failoverLbaStrategy: String,
    public val failoverMaxReturnAddrNum: Int,
    public val failoverMinAvailableAddrNum: Int,
    public val id: String,
    public val instanceId: String,
    public val lines: List<GetAccessStrategiesStrategyLine>,
    public val strategyMode: String,
    public val strategyName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAccessStrategiesStrategy): GetAccessStrategiesStrategy = GetAccessStrategiesStrategy(
            accessMode = javaType.accessMode(),
            accessStrategyId = javaType.accessStrategyId(),
            createTime = javaType.createTime(),
            createTimestamp = javaType.createTimestamp(),
            defaultAddrPoolType = javaType.defaultAddrPoolType(),
            defaultAddrPools = javaType.defaultAddrPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesStrategyDefaultAddrPool.Companion.toKotlin(args0)
                })
            }),
            defaultAvailableAddrNum = javaType.defaultAvailableAddrNum(),
            defaultLatencyOptimization = javaType.defaultLatencyOptimization(),
            defaultLbaStrategy = javaType.defaultLbaStrategy(),
            defaultMaxReturnAddrNum = javaType.defaultMaxReturnAddrNum(),
            defaultMinAvailableAddrNum = javaType.defaultMinAvailableAddrNum(),
            effectiveAddrPoolGroupType = javaType.effectiveAddrPoolGroupType(),
            failoverAddrPoolType = javaType.failoverAddrPoolType(),
            failoverAddrPools = javaType.failoverAddrPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesStrategyFailoverAddrPool.Companion.toKotlin(args0)
                })
            }),
            failoverAvailableAddrNum = javaType.failoverAvailableAddrNum(),
            failoverLatencyOptimization = javaType.failoverLatencyOptimization(),
            failoverLbaStrategy = javaType.failoverLbaStrategy(),
            failoverMaxReturnAddrNum = javaType.failoverMaxReturnAddrNum(),
            failoverMinAvailableAddrNum = javaType.failoverMinAvailableAddrNum(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            lines = javaType.lines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAccessStrategiesStrategyLine.Companion.toKotlin(args0)
                })
            }),
            strategyMode = javaType.strategyMode(),
            strategyName = javaType.strategyName(),
        )
    }
}
