@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property addrCount The number of addresses in the address pool.
 * @property addrPoolId The ID of the address pool.
 * @property lbaWeight The weight of the address pool.
 * @property name The name of the address pool.
 */
public data class GetAccessStrategiesStrategyFailoverAddrPool(
    public val addrCount: Int,
    public val addrPoolId: String,
    public val lbaWeight: Int,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAccessStrategiesStrategyFailoverAddrPool): GetAccessStrategiesStrategyFailoverAddrPool = GetAccessStrategiesStrategyFailoverAddrPool(
            addrCount = javaType.addrCount(),
            addrPoolId = javaType.addrPoolId(),
            lbaWeight = javaType.lbaWeight(),
            name = javaType.name(),
        )
    }
}
