@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property groupCode The code of the source region group.
 * @property groupName The name of the source region group.
 * @property lineCode The line code of the source region.
 * @property lineName The line name of the source region.
 */
public data class GetAccessStrategiesStrategyLine(
    public val groupCode: String,
    public val groupName: String,
    public val lineCode: String,
    public val lineName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAccessStrategiesStrategyLine): GetAccessStrategiesStrategyLine = GetAccessStrategiesStrategyLine(
            groupCode = javaType.groupCode(),
            groupName = javaType.groupName(),
            lineCode = javaType.lineCode(),
            lineName = javaType.lineName(),
        )
    }
}
