@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property addressPoolId The first ID of the resource.
 * @property addressPoolName The name of the address pool.
 * @property addresses The address lists of the Address Pool.
 * @property createTime The time when the address pool was created.
 * @property createTimestamp The timestamp that indicates when the address pool was created.
 * @property id The ID of the Address Pool.
 * @property instanceId The id of the instance.
 * @property lbaStrategy The load balancing policy of the address pool.
 * @property monitorConfigId The ID of the health check task.
 * @property monitorStatus Indicates whether health checks are configured.
 * @property type The type of the address pool.
 * @property updateTime The time when the address pool was updated.
 * @property updateTimestamp The timestamp that indicates when the address pool was updated.
 */
public data class GetAddressPoolsPool(
    public val addressPoolId: String,
    public val addressPoolName: String,
    public val addresses: List<GetAddressPoolsPoolAddress>,
    public val createTime: String,
    public val createTimestamp: String,
    public val id: String,
    public val instanceId: String,
    public val lbaStrategy: String,
    public val monitorConfigId: String,
    public val monitorStatus: String,
    public val type: String,
    public val updateTime: String,
    public val updateTimestamp: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAddressPoolsPool): GetAddressPoolsPool = GetAddressPoolsPool(
            addressPoolId = javaType.addressPoolId(),
            addressPoolName = javaType.addressPoolName(),
            addresses = javaType.addresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAddressPoolsPoolAddress.Companion.toKotlin(args0)
                })
            }),
            createTime = javaType.createTime(),
            createTimestamp = javaType.createTimestamp(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            lbaStrategy = javaType.lbaStrategy(),
            monitorConfigId = javaType.monitorConfigId(),
            monitorStatus = javaType.monitorStatus(),
            type = javaType.type(),
            updateTime = javaType.updateTime(),
            updateTimestamp = javaType.updateTimestamp(),
        )
    }
}
