@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property address The address that you want to add to the address pool.
 * @property attributeInfo The source region of the address.
 * @property lbaWeight The weight of the address.
 * @property mode The type of the address.
 * @property remark The description of the address.
 */
public data class GetAddressPoolsPoolAddress(
    public val address: String,
    public val attributeInfo: String,
    public val lbaWeight: Int,
    public val mode: String,
    public val remark: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAddressPoolsPoolAddress): GetAddressPoolsPoolAddress = GetAddressPoolsPoolAddress(
            address = javaType.address(),
            attributeInfo = javaType.attributeInfo(),
            lbaWeight = javaType.lbaWeight(),
            mode = javaType.mode(),
            remark = javaType.remark(),
        )
    }
}
