@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 *
 * @property aliDomain Specifies whether the domain is from Alibaba Cloud or not.
 * @property availableTtls List of available TTLs.
 * @property dnsServers DNS list of domain names in the resolution system.
 * @property domainId ID of the domain.
 * @property domainName Name of the domain.
 * @property groupId Domain group ID, if not filled, the default is all groups.
 * @property groupName Name of group that contains the domain.
 * @property id The Id of resource.
 * @property inBlackHole Whether it is in black hole.
 * @property inClean Whether it is cleaning.
 * @property instanceId Cloud analysis product ID.
 * @property lineType
 * @property minTtl Minimum TTL.
 * @property punyCode Punycode of the Chinese domain.
 * @property recordLineTreeJson Tree-like analytical line list.
 * @property recordLines Parse the line data list.
 * @property regionLines Whether it is a regional route.
 * @property remark The Id of resource group which the dns belongs.
 * @property resourceGroupId The Id of resource group which the dns belongs.
 * @property slaveDns Whether to allow auxiliary dns.
 * @property tags A mapping of tags to assign to the resource.
 * @property versionCode Cloud analysis version code.
 * @property versionName
 */
public data class GetAlidnsDomainsDomain(
    public val aliDomain: Boolean,
    public val availableTtls: List<Int>,
    public val dnsServers: List<String>,
    public val domainId: String,
    public val domainName: String,
    public val groupId: String,
    public val groupName: String,
    public val id: String,
    public val inBlackHole: Boolean,
    public val inClean: Boolean,
    public val instanceId: String,
    public val lineType: String,
    public val minTtl: Int,
    public val punyCode: String,
    public val recordLineTreeJson: String,
    public val recordLines: List<GetAlidnsDomainsDomainRecordLine>,
    public val regionLines: Boolean,
    public val remark: String,
    public val resourceGroupId: String,
    public val slaveDns: Boolean,
    public val tags: Map<String, String>,
    public val versionCode: String,
    public val versionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsDomainsDomain): GetAlidnsDomainsDomain = GetAlidnsDomainsDomain(
            aliDomain = javaType.aliDomain(),
            availableTtls = javaType.availableTtls().map({ args0 -> args0 }),
            dnsServers = javaType.dnsServers().map({ args0 -> args0 }),
            domainId = javaType.domainId(),
            domainName = javaType.domainName(),
            groupId = javaType.groupId(),
            groupName = javaType.groupName(),
            id = javaType.id(),
            inBlackHole = javaType.inBlackHole(),
            inClean = javaType.inClean(),
            instanceId = javaType.instanceId(),
            lineType = javaType.lineType(),
            minTtl = javaType.minTtl(),
            punyCode = javaType.punyCode(),
            recordLineTreeJson = javaType.recordLineTreeJson(),
            recordLines = javaType.recordLines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainsDomainRecordLine.Companion.toKotlin(args0)
                })
            }),
            regionLines = javaType.regionLines(),
            remark = javaType.remark(),
            resourceGroupId = javaType.resourceGroupId(),
            slaveDns = javaType.slaveDns(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            versionCode = javaType.versionCode(),
            versionName = javaType.versionName(),
        )
    }
}
