@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAlidnsDomains.
 * @property aliDomain Indicates whether the domain is an Alibaba Cloud domain.
 * @property domainNameRegex
 * @property domains A list of domains. Each element contains the following attributes:
 * @property enableDetails
 * @property groupId Id of group that contains the domain.
 * @property groupNameRegex
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of domain IDs.
 * @property instanceId Cloud analysis product ID of the domain.
 * @property keyWord
 * @property lang
 * @property names A list of domain names.
 * @property outputFile
 * @property resourceGroupId The Id of resource group which the dns belongs.
 * @property searchMode
 * @property starmark
 * @property tags
 * @property versionCode Cloud resolution version ID.
 */
public data class GetAlidnsDomainsResult(
    public val aliDomain: Boolean? = null,
    public val domainNameRegex: String? = null,
    public val domains: List<GetAlidnsDomainsDomain>,
    public val enableDetails: Boolean? = null,
    public val groupId: String? = null,
    public val groupNameRegex: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instanceId: String? = null,
    public val keyWord: String? = null,
    public val lang: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val resourceGroupId: String? = null,
    public val searchMode: String? = null,
    public val starmark: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val versionCode: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsDomainsResult): GetAlidnsDomainsResult = GetAlidnsDomainsResult(
            aliDomain = javaType.aliDomain().map({ args0 -> args0 }).orElse(null),
            domainNameRegex = javaType.domainNameRegex().map({ args0 -> args0 }).orElse(null),
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            groupNameRegex = javaType.groupNameRegex().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instanceId = javaType.instanceId().map({ args0 -> args0 }).orElse(null),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
            searchMode = javaType.searchMode().map({ args0 -> args0 }).orElse(null),
            starmark = javaType.starmark().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            versionCode = javaType.versionCode().map({ args0 -> args0 }).orElse(null),
        )
    }
}
