@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dnsSecurity DNS security level.
 * @property domain (Available in 1.124.1+) The domain name.
 * @property domainNumbers Number of domain names bound.
 * @property id Id of the instance.
 * @property instanceId Id of the instance resource.
 * @property paymentType (Available in 1.124.1+) The payment type of alidns instance.
 * @property versionCode Paid package version.
 * @property versionName Paid package version name.
 */
public data class GetAlidnsInstancesInstance(
    public val dnsSecurity: String,
    public val domain: String,
    public val domainNumbers: String,
    public val id: String,
    public val instanceId: String,
    public val paymentType: String,
    public val versionCode: String,
    public val versionName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsInstancesInstance): GetAlidnsInstancesInstance = GetAlidnsInstancesInstance(
            dnsSecurity = javaType.dnsSecurity(),
            domain = javaType.domain(),
            domainNumbers = javaType.domainNumbers(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            paymentType = javaType.paymentType(),
            versionCode = javaType.versionCode(),
            versionName = javaType.versionName(),
        )
    }
}
