@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlidnsInstances.
 * @property domainType
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of instance IDs.
 * @property instances A list of instances. Each element contains the following attributes:
 * @property lang
 * @property outputFile
 * @property userClientIp
 */
public data class GetAlidnsInstancesResult(
    public val domainType: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetAlidnsInstancesInstance>,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val userClientIp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsInstancesResult): GetAlidnsInstancesResult = GetAlidnsInstancesResult(
            domainType = javaType.domainType().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            userClientIp = javaType.userClientIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
