@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The domain name associated to the records.
 * @property id ID of the resource.
 * @property line ISP line. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/alibaba-cloud-dns/latest/dns-lines)
 * @property locked Indicates whether the record is locked.
 * @property priority Priority of the `MX` record.
 * @property recordId ID of the record.
 * @property remark The remark of the domain record.  **NOTE:** Available in 1.144.0+.
 * @property rr Host record of the domain.
 * @property status Record status. Valid values: `ENABLE` and `DISABLE`.
 * @property ttl TTL of the record.
 * @property type Record type. Valid values: `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
 * @property value Host record value of the domain.
 */
public data class GetAlidnsRecordsRecord(
    public val domainName: String,
    public val id: String,
    public val line: String,
    public val locked: Boolean,
    public val priority: Int,
    public val recordId: String,
    public val remark: String,
    public val rr: String,
    public val status: String,
    public val ttl: Int,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsRecordsRecord): GetAlidnsRecordsRecord = GetAlidnsRecordsRecord(
            domainName = javaType.domainName(),
            id = javaType.id(),
            line = javaType.line(),
            locked = javaType.locked(),
            priority = javaType.priority(),
            recordId = javaType.recordId(),
            remark = javaType.remark(),
            rr = javaType.rr(),
            status = javaType.status(),
            ttl = javaType.ttl(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
