@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlidnsRecords.
 * @property direction
 * @property domainName Name of the domain record belongs to.
 * @property groupId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of record IDs.
 * @property keyWord
 * @property lang
 * @property line ISP line of the record.
 * @property orderBy
 * @property outputFile
 * @property records A list of records. Each element contains the following attributes:
 * @property rrKeyWord
 * @property rrRegex
 * @property searchMode
 * @property status Status of the record.
 * @property type Type of the record.
 * @property typeKeyWord
 * @property valueKeyWord
 * @property valueRegex
 */
public data class GetAlidnsRecordsResult(
    public val direction: String? = null,
    public val domainName: String,
    public val groupId: Int? = null,
    public val id: String,
    public val ids: List<String>,
    public val keyWord: String? = null,
    public val lang: String? = null,
    public val line: String? = null,
    public val orderBy: String? = null,
    public val outputFile: String? = null,
    public val records: List<GetAlidnsRecordsRecord>,
    public val rrKeyWord: String? = null,
    public val rrRegex: String? = null,
    public val searchMode: String? = null,
    public val status: String? = null,
    public val type: String? = null,
    public val typeKeyWord: String? = null,
    public val valueKeyWord: String? = null,
    public val valueRegex: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetAlidnsRecordsResult): GetAlidnsRecordsResult = GetAlidnsRecordsResult(
            direction = javaType.direction().map({ args0 -> args0 }).orElse(null),
            domainName = javaType.domainName(),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            keyWord = javaType.keyWord().map({ args0 -> args0 }).orElse(null),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            line = javaType.line().map({ args0 -> args0 }).orElse(null),
            orderBy = javaType.orderBy().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            records = javaType.records().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetAlidnsRecordsRecord.Companion.toKotlin(args0)
                })
            }),
            rrKeyWord = javaType.rrKeyWord().map({ args0 -> args0 }).orElse(null),
            rrRegex = javaType.rrRegex().map({ args0 -> args0 }).orElse(null),
            searchMode = javaType.searchMode().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            typeKeyWord = javaType.typeKeyWord().map({ args0 -> args0 }).orElse(null),
            valueKeyWord = javaType.valueKeyWord().map({ args0 -> args0 }).orElse(null),
            valueRegex = javaType.valueRegex().map({ args0 -> args0 }).orElse(null),
        )
    }
}
