@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property code The Custom line Code.
 * @property customLineId The first ID of the resource.
 * @property customLineName Line name.
 * @property domainName The Domain name.
 * @property id The ID of the Custom Line.
 * @property ipSegmentLists The IP segment list.
 */
public data class GetCustomLinesLine(
    public val code: String,
    public val customLineId: String,
    public val customLineName: String,
    public val domainName: String,
    public val id: String,
    public val ipSegmentLists: List<GetCustomLinesLineIpSegmentList>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetCustomLinesLine): GetCustomLinesLine = GetCustomLinesLine(
            code = javaType.code(),
            customLineId = javaType.customLineId(),
            customLineName = javaType.customLineName(),
            domainName = javaType.domainName(),
            id = javaType.id(),
            ipSegmentLists = javaType.ipSegmentLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetCustomLinesLineIpSegmentList.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
