@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomLines.
 * @property domainName
 * @property enableDetails
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property lang
 * @property lines
 * @property nameRegex
 * @property names
 * @property outputFile
 */
public data class GetCustomLinesResult(
    public val domainName: String,
    public val enableDetails: Boolean? = null,
    public val id: String,
    public val ids: List<String>,
    public val lang: String? = null,
    public val lines: List<GetCustomLinesLine>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetCustomLinesResult): GetCustomLinesResult = GetCustomLinesResult(
            domainName = javaType.domainName(),
            enableDetails = javaType.enableDetails().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            lines = javaType.lines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetCustomLinesLine.Companion.toKotlin(args0)
                })
            }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
