@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getDomainRecords.
 * @property domainName
 * @property hostRecordRegex
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property isLocked
 * @property line
 * @property outputFile
 * @property records
 * @property status
 * @property type
 * @property urls
 * @property valueRegex
 */
public data class GetDomainRecordsResult(
    public val domainName: String,
    public val hostRecordRegex: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val isLocked: Boolean? = null,
    public val line: String? = null,
    public val outputFile: String? = null,
    public val records: List<GetDomainRecordsRecord>,
    public val status: String? = null,
    public val type: String? = null,
    public val urls: List<String>,
    public val valueRegex: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetDomainRecordsResult): GetDomainRecordsResult = GetDomainRecordsResult(
            domainName = javaType.domainName(),
            hostRecordRegex = javaType.hostRecordRegex().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isLocked = javaType.isLocked().map({ args0 -> args0 }).orElse(null),
            line = javaType.line().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            records = javaType.records().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetDomainRecordsRecord.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            urls = javaType.urls().map({ args0 -> args0 }),
            valueRegex = javaType.valueRegex().map({ args0 -> args0 }).orElse(null),
        )
    }
}
