@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getDomainTxtGuid.
 * @property domainName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lang
 * @property outputFile
 * @property rr Host record.
 * @property type
 * @property value Record the value.
 */
public data class GetDomainTxtGuidResult(
    public val domainName: String,
    public val id: String,
    public val lang: String? = null,
    public val outputFile: String? = null,
    public val rr: String,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetDomainTxtGuidResult): GetDomainTxtGuidResult = GetDomainTxtGuidResult(
            domainName = javaType.domainName(),
            id = javaType.id(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rr = javaType.rr(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
