@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alertConfigs The alert notification methods.
 * @property alertGroups The alert group.
 * @property cnameType The access type of the CNAME domain name.
 * @property createTime The CreateTime of the Gtm Instance.
 * @property expireTime The ExpireTime of the Gtm Instance.
 * @property id The ID of the Gtm Instance.
 * @property instanceId The ID of the Gtm Instance.
 * @property instanceName The name of the Gtm Instance.
 * @property packageEdition The version of the instance.
 * @property paymentType The paymentype of the resource.
 * @property publicCnameMode The Public Network domain name access method.
 * @property publicRr The CNAME access domain name.
 * @property publicUserDomainName The website domain name that the user uses on the Internet.
 * @property publicZoneName The domain name that is used to access GTM over the Internet.
 * @property resourceGroupId The ID of the resource group.
 * @property strategyMode The type of the access policy.
 * @property ttl The global time to live.
 */
public data class GetGtmInstancesInstance(
    public val alertConfigs: List<GetGtmInstancesInstanceAlertConfig>,
    public val alertGroups: List<String>,
    public val cnameType: String,
    public val createTime: String,
    public val expireTime: String,
    public val id: String,
    public val instanceId: String,
    public val instanceName: String,
    public val packageEdition: String,
    public val paymentType: String,
    public val publicCnameMode: String,
    public val publicRr: String,
    public val publicUserDomainName: String,
    public val publicZoneName: String,
    public val resourceGroupId: String,
    public val strategyMode: String,
    public val ttl: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetGtmInstancesInstance): GetGtmInstancesInstance = GetGtmInstancesInstance(
            alertConfigs = javaType.alertConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetGtmInstancesInstanceAlertConfig.Companion.toKotlin(args0)
                })
            }),
            alertGroups = javaType.alertGroups().map({ args0 -> args0 }),
            cnameType = javaType.cnameType(),
            createTime = javaType.createTime(),
            expireTime = javaType.expireTime(),
            id = javaType.id(),
            instanceId = javaType.instanceId(),
            instanceName = javaType.instanceName(),
            packageEdition = javaType.packageEdition(),
            paymentType = javaType.paymentType(),
            publicCnameMode = javaType.publicCnameMode(),
            publicRr = javaType.publicRr(),
            publicUserDomainName = javaType.publicUserDomainName(),
            publicZoneName = javaType.publicZoneName(),
            resourceGroupId = javaType.resourceGroupId(),
            strategyMode = javaType.strategyMode(),
            ttl = javaType.ttl(),
        )
    }
}
