@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dingtalkNotice Whether to configure DingTalk notifications.
 * @property emailNotice Whether to configure mail notification.
 * @property noticeType The Alarm Event Type.
 * @property smsNotice Whether to configure SMS notification.
 */
public data class GetGtmInstancesInstanceAlertConfig(
    public val dingtalkNotice: Boolean,
    public val emailNotice: Boolean,
    public val noticeType: String,
    public val smsNotice: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetGtmInstancesInstanceAlertConfig): GetGtmInstancesInstanceAlertConfig = GetGtmInstancesInstanceAlertConfig(
            dingtalkNotice = javaType.dingtalkNotice(),
            emailNotice = javaType.emailNotice(),
            noticeType = javaType.noticeType(),
            smsNotice = javaType.smsNotice(),
        )
    }
}
