@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGtmInstances.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property instances
 * @property lang
 * @property outputFile
 * @property resourceGroupId
 */
public data class GetGtmInstancesResult(
    public val id: String,
    public val ids: List<String>,
    public val instances: List<GetGtmInstancesInstance>,
    public val lang: String? = null,
    public val outputFile: String,
    public val resourceGroupId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetGtmInstancesResult): GetGtmInstancesResult = GetGtmInstancesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            instances = javaType.instances().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetGtmInstancesInstance.Companion.toKotlin(args0)
                })
            }),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile(),
            resourceGroupId = javaType.resourceGroupId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
