@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property domainName The domain name associated to the records.
 * @property hostRecord Host record of the domain.
 * @property line ISP line. Valid items are `default`, `telecom`, `unicom`, `mobile`, `oversea`, `edu`, `drpeng`, `btvn`, .etc. For checking all resolution lines enumeration please visit [Alibaba Cloud DNS doc](https://www.alibabacloud.com/help/en/doc-detail/29807.htm)
 * @property locked Indicates whether the record is locked.
 * @property priority Priority of the `MX` record.
 * @property recordId ID of the record.
 * @property status Record status. Valid items are `ENABLE` and `DISABLE`.
 * @property ttl TTL of the record.
 * @property type Record type. Valid items are `A`, `NS`, `MX`, `TXT`, `CNAME`, `SRV`, `AAAA`, `REDIRECT_URL`, `FORWORD_URL` .
 * @property value Host record value of the domain.
 */
public data class GetRecordsRecord(
    public val domainName: String,
    public val hostRecord: String,
    public val line: String,
    public val locked: Boolean,
    public val priority: Int,
    public val recordId: String,
    public val status: String,
    public val ttl: Double,
    public val type: String,
    public val `value`: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetRecordsRecord): GetRecordsRecord = GetRecordsRecord(
            domainName = javaType.domainName(),
            hostRecord = javaType.hostRecord(),
            line = javaType.line(),
            locked = javaType.locked(),
            priority = javaType.priority(),
            recordId = javaType.recordId(),
            status = javaType.status(),
            ttl = javaType.ttl(),
            type = javaType.type(),
            `value` = javaType.`value`(),
        )
    }
}
