@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getRecords.
 * @property domainName Name of the domain the record belongs to.
 * @property hostRecordRegex
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of record IDs.
 * @property isLocked
 * @property line ISP line of the record.
 * @property outputFile
 * @property records A list of records. Each element contains the following attributes:
 * @property status Status of the record.
 * @property type Type of the record.
 * @property urls A list of entire URLs. Each item format as `<host_record>.<domain_name>`.
 * @property valueRegex
 */
public data class GetRecordsResult(
    public val domainName: String,
    public val hostRecordRegex: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val isLocked: Boolean? = null,
    public val line: String? = null,
    public val outputFile: String? = null,
    public val records: List<GetRecordsRecord>,
    public val status: String? = null,
    public val type: String? = null,
    public val urls: List<String>,
    public val valueRegex: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetRecordsResult): GetRecordsResult = GetRecordsResult(
            domainName = javaType.domainName(),
            hostRecordRegex = javaType.hostRecordRegex().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            isLocked = javaType.isLocked().map({ args0 -> args0 }).orElse(null),
            line = javaType.line().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            records = javaType.records().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetRecordsRecord.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            urls = javaType.urls().map({ args0 -> args0 }),
            valueRegex = javaType.valueRegex().map({ args0 -> args0 }).orElse(null),
        )
    }
}
