@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getResolutionLines.
 * @property domainName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property lang
 * @property lineCodes Line code.
 * @property lineDisplayNames A list of line display names.
 * @property lineNames
 * @property lines A list of cloud resolution line. Each element contains the following attributes:
 * @property outputFile
 * @property userClientIp
 */
public data class GetResolutionLinesResult(
    public val domainName: String? = null,
    public val id: String,
    public val lang: String? = null,
    public val lineCodes: List<String>,
    public val lineDisplayNames: List<String>,
    public val lineNames: List<String>? = null,
    public val lines: List<GetResolutionLinesLine>,
    public val outputFile: String? = null,
    public val userClientIp: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GetResolutionLinesResult): GetResolutionLinesResult = GetResolutionLinesResult(
            domainName = javaType.domainName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            lang = javaType.lang().map({ args0 -> args0 }).orElse(null),
            lineCodes = javaType.lineCodes().map({ args0 -> args0 }),
            lineDisplayNames = javaType.lineDisplayNames().map({ args0 -> args0 }),
            lineNames = javaType.lineNames().map({ args0 -> args0 }),
            lines = javaType.lines().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.dns.kotlin.outputs.GetResolutionLinesLine.Companion.toKotlin(args0)
                })
            }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            userClientIp = javaType.userClientIp().map({ args0 -> args0 }).orElse(null),
        )
    }
}
