@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.dns.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property dingtalkNotice Whether to configure DingTalk notifications. Valid values: `true`, `false`.
 * @property emailNotice Whether to configure mail notification. Valid values: `true`, `false`.
 * @property noticeType The Alarm Event Type.
 * - `ADDR_ALERT`: Address not available.
 * - `ADDR_RESUME`: Address Recovery available.
 * - `ADDR_POOL_GROUP_UNAVAILABLE`: Address pool collection not available.
 * - `ADDR_POOL_GROUP_AVAILABLE`: Address pool collection recovery available.
 * - `ACCESS_STRATEGY_POOL_GROUP_SWITCH`: Primary/standby address pool switch.
 * - `MONITOR_NODE_IP_CHANGE`: Monitoring node IP address changes.
 * @property smsNotice Whether to configure SMS notification. Valid values: `true`, `false`.
 */
public data class GtmInstanceAlertConfig(
    public val dingtalkNotice: Boolean? = null,
    public val emailNotice: Boolean? = null,
    public val noticeType: String? = null,
    public val smsNotice: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.dns.outputs.GtmInstanceAlertConfig): GtmInstanceAlertConfig = GtmInstanceAlertConfig(
            dingtalkNotice = javaType.dingtalkNotice().map({ args0 -> args0 }).orElse(null),
            emailNotice = javaType.emailNotice().map({ args0 -> args0 }).orElse(null),
            noticeType = javaType.noticeType().map({ args0 -> args0 }).orElse(null),
            smsNotice = javaType.smsNotice().map({ args0 -> args0 }).orElse(null),
        )
    }
}
